/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.util.impl.Contracts;

public class AssociationContextImpl
implements AssociationContext {
    private final AssociationTypeContext associationTypeContext;
    private final OperationsQueue operationsQueue;
    private final TuplePointer entityTuplePointer;
    private final TransactionContext transactionContext;

    public AssociationContextImpl(AssociationTypeContext associationTypeContext, TuplePointer entityTuplePointer, TransactionContext transactionContext) {
        this(associationTypeContext, entityTuplePointer, null, transactionContext);
    }

    public AssociationContextImpl(AssociationContextImpl original, OperationsQueue operationsQueue) {
        this(original.associationTypeContext, original.entityTuplePointer, operationsQueue, original.transactionContext);
    }

    private AssociationContextImpl(AssociationTypeContext associationTypeContext, TuplePointer entityTuplePointer, OperationsQueue operationsQueue, TransactionContext transactionContext) {
        Contracts.assertParameterNotNull(associationTypeContext, "associationTypeContext");
        this.associationTypeContext = associationTypeContext;
        this.entityTuplePointer = entityTuplePointer;
        this.operationsQueue = operationsQueue;
        this.transactionContext = transactionContext;
    }

    @Override
    public AssociationTypeContext getAssociationTypeContext() {
        return this.associationTypeContext;
    }

    @Override
    public OperationsQueue getOperationsQueue() {
        return this.operationsQueue;
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public TuplePointer getEntityTuplePointer() {
        return this.entityTuplePointer;
    }

    @Override
    public TupleTypeContext getTupleTypeContext() {
        return this.associationTypeContext.getOwnerEntityTupleTypeContext();
    }

    public String toString() {
        return "AssociationContextImpl [associationTypeContext=" + this.associationTypeContext + ", operationsQueue=" + this.operationsQueue + ", entityTuple=" + this.entityTuplePointer + "]";
    }
}

