/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import java.io.Serializable;
import org.hibernate.ogm.dialect.batch.spi.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.spi.GroupingByEntityDialect;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.batch.spi.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.RemoveTupleOperation;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManager;
import org.hibernate.ogm.dialect.impl.AssociationContextImpl;
import org.hibernate.ogm.dialect.impl.ForwardingGridDialect;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.impl.TupleContextImpl;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class BatchOperationsDelegator
extends ForwardingGridDialect<Serializable> {
    private static final Log log = LoggerFactory.make();
    private final EventContextManager eventContext;

    public BatchOperationsDelegator(GridDialect dialect, EventContextManager eventContext) {
        super(dialect);
        this.eventContext = eventContext;
    }

    private boolean isBatchDisabled() {
        return this.getOperationQueue().isClosed();
    }

    private OperationsQueue getOperationQueue() {
        OperationsQueue operationsQueue = null;
        if (this.eventContext.isActive()) {
            operationsQueue = this.eventContext.get(OperationsQueue.class);
        }
        if (operationsQueue == null) {
            return OperationsQueue.CLOSED_QUEUE;
        }
        return operationsQueue;
    }

    @Override
    public void executeBatch(OperationsQueue operationsQueue) {
        try {
            if (GridDialects.hasFacet(this.getGridDialect(), BatchableGridDialect.class) || GridDialects.hasFacet(this.getGridDialect(), GroupingByEntityDialect.class)) {
                log.tracef("Executing batch", new Object[0]);
                super.executeBatch(operationsQueue);
            }
        }
        catch (TupleAlreadyExistsException taee) {
            throw log.mustNotInsertSameEntityTwice(taee.getMessage(), (Exception)((Object)taee));
        }
    }

    @Override
    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        OperationContext contextWithQueue = operationContext instanceof AssociationContext ? new AssociationContextImpl((AssociationContextImpl)operationContext, this.getOperationQueue()) : new TupleContextImpl((TupleContextImpl)operationContext, this.getOperationQueue());
        return super.getTuple(key, contextWithQueue);
    }

    @Override
    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) {
        if (this.isBatchDisabled()) {
            super.insertOrUpdateTuple(key, tuplePointer, tupleContext);
        } else {
            this.getOperationQueue().add(new InsertOrUpdateTupleOperation(tuplePointer, key, tupleContext));
        }
    }

    @Override
    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        if (this.isBatchDisabled()) {
            super.removeTuple(key, tupleContext);
        } else {
            this.getOperationQueue().add(new RemoveTupleOperation(key, tupleContext));
        }
    }

    @Override
    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        return super.getAssociation(key, this.withQueue(associationContext));
    }

    @Override
    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        return super.createAssociation(key, this.withQueue(associationContext));
    }

    @Override
    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        if (this.isBatchDisabled()) {
            super.insertOrUpdateAssociation(key, association, this.withQueue(associationContext));
        } else {
            this.getOperationQueue().add(new InsertOrUpdateAssociationOperation(association, key, this.withQueue(associationContext)));
        }
    }

    @Override
    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (this.isBatchDisabled()) {
            super.removeAssociation(key, this.withQueue(associationContext));
        } else {
            this.getOperationQueue().add(new RemoveAssociationOperation(key, this.withQueue(associationContext)));
        }
    }

    @Override
    public void flushPendingOperations(EntityKey entityKey, TupleContext tupleContext) {
        super.flushPendingOperations(entityKey, this.withQueue(tupleContext));
    }

    private AssociationContext withQueue(AssociationContext associationContext) {
        return new AssociationContextImpl((AssociationContextImpl)associationContext, this.getOperationQueue());
    }

    private TupleContext withQueue(TupleContext tupleContext) {
        return new TupleContextImpl((TupleContextImpl)tupleContext, this.getOperationQueue());
    }
}

