/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import org.hibernate.ogm.dialect.impl.ForwardingGridDialect;
import org.hibernate.ogm.dialect.spi.GridDialect;

public class GridDialects {
    private GridDialects() {
    }

    static <T extends GridDialect> T getDialectFacetOrNull(GridDialect gridDialect, Class<T> facetType) {
        if (GridDialects.hasFacet(gridDialect, facetType)) {
            GridDialect asFacet = gridDialect;
            return (T)asFacet;
        }
        return null;
    }

    public static boolean hasFacet(GridDialect gridDialect, Class<? extends GridDialect> facetType) {
        if (gridDialect instanceof ForwardingGridDialect) {
            return GridDialects.hasFacet(((ForwardingGridDialect)gridDialect).getGridDialect(), facetType);
        }
        return facetType.isAssignableFrom(gridDialect.getClass());
    }

    public static Class<? extends GridDialect> getWrappedDialect(GridDialect gridDialect) {
        if (gridDialect instanceof ForwardingGridDialect) {
            return GridDialects.getWrappedDialect(((ForwardingGridDialect)gridDialect).getGridDialect());
        }
        return gridDialect.getClass();
    }

    public static <T extends GridDialect> T getDelegateOrNull(GridDialect gridDialect, Class<T> delegateType) {
        if (gridDialect.getClass() == delegateType) {
            return (T)((GridDialect)delegateType.cast(gridDialect));
        }
        if (gridDialect instanceof ForwardingGridDialect) {
            return GridDialects.getDelegateOrNull(((ForwardingGridDialect)gridDialect).getGridDialect(), delegateType);
        }
        return null;
    }
}

