/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.query.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.ogm.dialect.query.spi.RowSelection;
import org.hibernate.ogm.dialect.query.spi.TypedGridValue;
import org.hibernate.ogm.type.spi.TypeTranslator;

public class QueryParameters {
    private final RowSelection rowSelection;
    private final Map<String, TypedGridValue> namedParameters;
    private final List<TypedGridValue> positionalParameters;

    public QueryParameters(RowSelection rowSelection, Map<String, TypedGridValue> namedParameters, List<TypedGridValue> positionalParameters) {
        this.rowSelection = rowSelection;
        this.namedParameters = namedParameters;
        this.positionalParameters = positionalParameters;
    }

    public static QueryParameters fromOrmQueryParameters(org.hibernate.engine.spi.QueryParameters parameters, TypeTranslator typeTranslator, SessionFactoryImplementor sessionFactoryImplementor) {
        RowSelection selection = RowSelection.fromOrmRowSelection(parameters.getRowSelection());
        Map<String, TypedGridValue> namedParameters = QueryParameters.createNamedParameters(sessionFactoryImplementor, parameters, typeTranslator);
        List<TypedGridValue> positionalParameters = QueryParameters.createPositionalParameters(parameters, typeTranslator);
        return new QueryParameters(selection, namedParameters, positionalParameters);
    }

    private static List<TypedGridValue> createPositionalParameters(org.hibernate.engine.spi.QueryParameters parameters, TypeTranslator typeTranslator) {
        ArrayList<TypedGridValue> positionalParameters = new ArrayList<TypedGridValue>(parameters.getPositionalParameterTypes().length);
        for (int i = 0; i < parameters.getPositionalParameterTypes().length; ++i) {
            positionalParameters.add(new TypedGridValue(typeTranslator.getType(parameters.getPositionalParameterTypes()[i]), parameters.getPositionalParameterValues()[i]));
        }
        return positionalParameters;
    }

    private static Map<String, TypedGridValue> createNamedParameters(SessionFactoryImplementor factory, org.hibernate.engine.spi.QueryParameters parameters, TypeTranslator typeTranslator) {
        HashMap<String, TypedGridValue> namedParameters = new HashMap<String, TypedGridValue>();
        for (Map.Entry parameter : parameters.getNamedParameters().entrySet()) {
            TypedGridValue typedGridValue = TypedGridValue.fromOrmTypedValue((TypedValue)parameter.getValue(), typeTranslator, factory);
            namedParameters.put((String)parameter.getKey(), typedGridValue);
        }
        return namedParameters;
    }

    public RowSelection getRowSelection() {
        return this.rowSelection;
    }

    public Map<String, TypedGridValue> getNamedParameters() {
        return this.namedParameters;
    }

    public List<TypedGridValue> getPositionalParameters() {
        return this.positionalParameters;
    }
}

