/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.id.impl;

import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.identity.GetGeneratedKeysDelegate;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.ogm.dialect.identity.spi.IdentityColumnAwareGridDialect;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.spi.GridDialect;

public class OgmIdentityColumnSupport
implements IdentityColumnSupport {
    public final boolean supportIdGenerationDuringInsert;

    public OgmIdentityColumnSupport(GridDialect gridDialect) {
        this.supportIdGenerationDuringInsert = GridDialects.hasFacet(gridDialect, IdentityColumnAwareGridDialect.class);
    }

    public boolean supportsIdentityColumns() {
        return this.supportIdGenerationDuringInsert;
    }

    public boolean supportsInsertSelectIdentity() {
        return false;
    }

    public boolean hasDataTypeInIdentityColumn() {
        return true;
    }

    public String appendIdentitySelectToInsert(String insertString) {
        return insertString;
    }

    public String getIdentitySelectString(String table, String column, int type) throws MappingException {
        throw new MappingException(this.getClass().getName() + " does not support identity key generation");
    }

    public String getIdentityColumnString(int type) throws MappingException {
        throw new MappingException(this.getClass().getName() + " does not support identity key generation");
    }

    public String getIdentityInsertString() {
        return null;
    }

    public GetGeneratedKeysDelegate buildGetGeneratedKeysDelegate(PostInsertIdentityPersister persister, Dialect dialect) {
        return new GetGeneratedKeysDelegate(persister, dialect);
    }
}

