/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.key.spi;

import java.util.Arrays;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;

public final class EntityKey {
    private final EntityKeyMetadata keyMetadata;
    private final int hashCode;
    private final Object[] columnValues;

    public EntityKey(EntityKeyMetadata keyMetadata, Object[] values) {
        this.keyMetadata = keyMetadata;
        this.columnValues = values;
        this.hashCode = this.generateHashCode();
    }

    public String getTable() {
        return this.keyMetadata.getTable();
    }

    public Object[] getColumnValues() {
        return this.columnValues;
    }

    public String[] getColumnNames() {
        return this.keyMetadata.getColumnNames();
    }

    public EntityKeyMetadata getMetadata() {
        return this.keyMetadata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityKey(");
        sb.append(this.getTable());
        sb.append(") [");
        int i = 0;
        for (String column : this.keyMetadata.getColumnNames()) {
            sb.append(column).append("=").append(this.columnValues[i]);
            if (++i >= this.keyMetadata.getColumnNames().length) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || EntityKey.class != o.getClass()) {
            return false;
        }
        EntityKey entityKey = (EntityKey)o;
        if (!Arrays.equals(this.columnValues, entityKey.columnValues)) {
            return false;
        }
        return this.keyMetadata.equals(entityKey.keyMetadata);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int result = this.keyMetadata.hashCode();
        result = 31 * result + Arrays.hashCode(this.columnValues);
        return result;
    }
}

