/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.navigation.source.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.options.container.impl.OptionsContainer;
import org.hibernate.ogm.options.container.impl.OptionsContainerBuilder;
import org.hibernate.ogm.options.navigation.impl.AppendableConfigurationContext;
import org.hibernate.ogm.options.navigation.impl.PropertyKey;
import org.hibernate.ogm.options.navigation.source.impl.OptionValueSource;
import org.hibernate.ogm.util.impl.CollectionHelper;

public class ProgrammaticOptionValueSource
implements OptionValueSource {
    private final OptionsContainer globalOptions;
    private final Map<Class<?>, OptionsContainer> optionsPerEntity;
    private final Map<PropertyKey, OptionsContainer> optionsPerProperty;

    public ProgrammaticOptionValueSource(AppendableConfigurationContext programmaticOptions) {
        this.globalOptions = programmaticOptions.getGlobalOptions().build();
        this.optionsPerEntity = ProgrammaticOptionValueSource.immutable(programmaticOptions.getEntityOptions());
        this.optionsPerProperty = ProgrammaticOptionValueSource.immutable(programmaticOptions.getPropertyOptions());
    }

    private static <K> Map<K, OptionsContainer> immutable(Map<K, OptionsContainerBuilder> options) {
        HashMap<K, OptionsContainer> result = CollectionHelper.newHashMap(options.size());
        for (Map.Entry<K, OptionsContainerBuilder> option : options.entrySet()) {
            result.put(option.getKey(), option.getValue().build());
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public OptionsContainer getGlobalOptions() {
        return this.globalOptions;
    }

    @Override
    public OptionsContainer getEntityOptions(Class<?> entityType) {
        OptionsContainer entityOptions = this.optionsPerEntity.get(entityType);
        return entityOptions != null ? entityOptions : OptionsContainer.EMPTY;
    }

    @Override
    public OptionsContainer getPropertyOptions(Class<?> entityType, String propertyName) {
        OptionsContainer propertyOptions = this.optionsPerProperty.get(new PropertyKey(entityType, propertyName));
        return propertyOptions != null ? propertyOptions : OptionsContainer.EMPTY;
    }
}

