/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.shared.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.options.shared.spi.IndexOption;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.hibernate.ogm.util.impl.StringHelper;

public class IndexOptions {
    private final Map<String, IndexOption> indexOptions;

    public IndexOptions() {
        this.indexOptions = Collections.emptyMap();
    }

    public IndexOptions(org.hibernate.ogm.options.shared.IndexOptions annotation) {
        HashMap<String, IndexOption> indexOptions = CollectionHelper.newHashMap(annotation.value().length);
        for (org.hibernate.ogm.options.shared.IndexOption optionAnnotation : annotation.value()) {
            indexOptions.put(optionAnnotation.forIndex(), new IndexOption(optionAnnotation));
        }
        this.indexOptions = Collections.unmodifiableMap(indexOptions);
    }

    public IndexOption getOptionForIndex(String indexName) {
        if (StringHelper.isNullOrEmptyString(indexName)) {
            return new IndexOption();
        }
        if (!this.indexOptions.containsKey(indexName)) {
            return new IndexOption(indexName);
        }
        return this.indexOptions.get(indexName);
    }

    public Set<String> getReferencedIndexes() {
        return Collections.unmodifiableSet(this.indexOptions.keySet());
    }
}

