/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.persister.impl;

import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.hibernate.ogm.persister.impl.ColumnBasedDiscriminator;
import org.hibernate.ogm.persister.impl.EntityDiscriminator;
import org.hibernate.ogm.persister.impl.NotNeededDiscriminator;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.persister.spi.PersisterCreationContext;

public class SingleTableOgmEntityPersister
extends OgmEntityPersister {
    public SingleTableOgmEntityPersister(PersistentClass persistentClass, EntityRegionAccessStrategy cacheAccessStrategy, NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy, PersisterCreationContext creationContext) throws HibernateException {
        super(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, creationContext, SingleTableOgmEntityPersister.resolveDiscriminator(persistentClass, creationContext.getSessionFactory()));
    }

    private static EntityDiscriminator resolveDiscriminator(PersistentClass persistentClass, SessionFactoryImplementor factory) {
        if (persistentClass.isPolymorphic()) {
            Value discrimValue = persistentClass.getDiscriminator();
            Selectable selectable = (Selectable)discrimValue.getColumnIterator().next();
            if (discrimValue.hasFormula()) {
                throw new UnsupportedOperationException("OGM doesn't support discriminator formulas");
            }
            return new ColumnBasedDiscriminator(persistentClass, factory, (Column)selectable);
        }
        return NotNeededDiscriminator.INSTANCE;
    }

    protected String filterFragment(String alias, Set<String> treatAsDeclarations) {
        return null;
    }
}

