/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.cfg.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.ogm.cfg.spi.Hosts;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class HostParser {
    private static final Pattern HOST_AND_PORT_PATTERN = Pattern.compile("^([^\\[\\]:\\s]+|\\[[\\da-fA-F:\\.]+\\]|[\\da-fA-F:\\.]+)(:(\\d+))*$");
    private static final Pattern NAKED_IPV6_PATTERN = Pattern.compile("^\\[(.+)\\]$");
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    public static Hosts parse(String hostString, Integer explicitGlobalPort, Integer defaultPort) {
        String[] splits;
        ArrayList<String> hosts = new ArrayList<String>();
        ArrayList<Integer> ports = new ArrayList<Integer>();
        if (hostString == null || hostString.trim().isEmpty()) {
            return Hosts.NO_HOST;
        }
        for (String rawSplit : splits = hostString.split(",")) {
            String split = rawSplit.trim();
            Matcher matcher = HOST_AND_PORT_PATTERN.matcher(split);
            if (!matcher.matches()) {
                throw LOG.unableToParseHost(hostString);
            }
            HostParser.setCleanHost(matcher, hosts);
            HostParser.setPort(ports, matcher, explicitGlobalPort, splits, defaultPort);
        }
        return new Hosts(hosts, ports);
    }

    private static void setPort(List<Integer> ports, Matcher matcher, Integer globalPort, String[] splits, Integer defaultPort) {
        String portAsString = matcher.group(3);
        if (portAsString != null) {
            ports.add(Integer.valueOf(portAsString));
        } else if (splits.length == 1 && globalPort != null) {
            ports.add(globalPort);
        } else {
            ports.add(defaultPort);
        }
    }

    private static void setCleanHost(Matcher matcher, List<String> hosts) {
        String maybeIPv6Host = matcher.group(1);
        Matcher ipv6Matcher = NAKED_IPV6_PATTERN.matcher(maybeIPv6Host);
        String cleanHost = maybeIPv6Host;
        if (ipv6Matcher.matches() && (cleanHost = ipv6Matcher.group(1)) == null) {
            cleanHost = maybeIPv6Host;
        }
        hosts.add(cleanHost);
    }
}

