/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.compensation.impl;

import java.io.Serializable;
import java.util.ArrayList;
import org.hibernate.ogm.compensation.ErrorHandlingStrategy;
import org.hibernate.ogm.compensation.impl.OperationCollector;
import org.hibernate.ogm.compensation.operation.GridDialectOperation;
import org.hibernate.ogm.compensation.operation.impl.CreateAssociationWithKeyImpl;
import org.hibernate.ogm.compensation.operation.impl.CreateTupleImpl;
import org.hibernate.ogm.compensation.operation.impl.CreateTupleWithKeyImpl;
import org.hibernate.ogm.compensation.operation.impl.ExecuteBatchImpl;
import org.hibernate.ogm.compensation.operation.impl.FlushPendingOperationsImpl;
import org.hibernate.ogm.compensation.operation.impl.InsertOrUpdateAssociationImpl;
import org.hibernate.ogm.compensation.operation.impl.InsertOrUpdateTupleImpl;
import org.hibernate.ogm.compensation.operation.impl.InsertTupleImpl;
import org.hibernate.ogm.compensation.operation.impl.RemoveAssociationImpl;
import org.hibernate.ogm.compensation.operation.impl.RemoveTupleImpl;
import org.hibernate.ogm.compensation.operation.impl.RemoveTupleWithOptimisticLockImpl;
import org.hibernate.ogm.compensation.operation.impl.UpdateTupleWithOptimisticLockImpl;
import org.hibernate.ogm.dialect.batch.spi.GroupedChangesToEntityOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.Operation;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.batch.spi.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.RemoveTupleOperation;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManager;
import org.hibernate.ogm.dialect.impl.ForwardingGridDialect;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.exception.impl.Exceptions;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.Tuple;

public class InvocationCollectingGridDialect
extends ForwardingGridDialect<Serializable> {
    private final EventContextManager eventContext;

    public InvocationCollectingGridDialect(GridDialect gridDialect, EventContextManager eventContextManager) {
        super(gridDialect);
        this.eventContext = eventContextManager;
    }

    @Override
    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) {
        InsertOrUpdateTupleImpl insertOrUpdateTuple = new InsertOrUpdateTupleImpl(key, tuplePointer.getTuple());
        try {
            super.insertOrUpdateTuple(key, tuplePointer, tupleContext);
        }
        catch (Exception e) {
            this.handleException(insertOrUpdateTuple, e);
        }
        this.handleAppliedOperation(insertOrUpdateTuple);
    }

    public void onInsertOrUpdateTupleFailure(EntityKey key, Tuple tuple, TupleAlreadyExistsException e) {
        this.handleException(new InsertOrUpdateTupleImpl(key, tuple), (Exception)((Object)e));
    }

    @Override
    public void executeBatch(OperationsQueue queue) {
        OperationsQueue newQueue = new OperationsQueue();
        ArrayList<GridDialectOperation> operations = new ArrayList<GridDialectOperation>();
        if (!queue.isClosed()) {
            Operation operation = queue.poll();
            while (operation != null) {
                newQueue.add(operation);
                if (operation instanceof GroupedChangesToEntityOperation) {
                    GroupedChangesToEntityOperation groupedChangesOnEntity = (GroupedChangesToEntityOperation)operation;
                    for (Operation groupedOperation : groupedChangesOnEntity.getOperations()) {
                        operations.add(this.getSimpleGridDialectOperations(groupedOperation));
                    }
                } else {
                    operations.add(this.getSimpleGridDialectOperations(operation));
                }
                operation = queue.poll();
            }
        }
        ExecuteBatchImpl executeBatch = new ExecuteBatchImpl(operations);
        try {
            super.executeBatch(newQueue);
        }
        catch (Exception e) {
            this.handleException(executeBatch, e);
        }
        this.handleAppliedOperation(executeBatch);
    }

    @Override
    public void flushPendingOperations(EntityKey entityKey, TupleContext tupleContext) {
        OperationsQueue queue = tupleContext.getOperationsQueue();
        OperationsQueue newQueue = new OperationsQueue();
        ArrayList<GridDialectOperation> operations = new ArrayList<GridDialectOperation>();
        if (!queue.isClosed()) {
            Operation operation = queue.poll();
            while (operation != null) {
                newQueue.add(operation);
                if (operation instanceof GroupedChangesToEntityOperation) {
                    GroupedChangesToEntityOperation groupedChangesOnEntity = (GroupedChangesToEntityOperation)operation;
                    for (Operation groupedOperation : groupedChangesOnEntity.getOperations()) {
                        operations.add(this.getSimpleGridDialectOperations(groupedOperation));
                    }
                } else {
                    operations.add(this.getSimpleGridDialectOperations(operation));
                }
                operation = queue.poll();
            }
        }
        FlushPendingOperationsImpl flushPendingOperations = new FlushPendingOperationsImpl(operations);
        try {
            super.flushPendingOperations(entityKey, tupleContext);
        }
        catch (Exception e) {
            this.handleException(flushPendingOperations, e);
        }
        this.handleAppliedOperation(flushPendingOperations);
    }

    private GridDialectOperation getSimpleGridDialectOperations(Operation operation) {
        GridDialectOperation gridDialectOperation;
        if (operation instanceof InsertOrUpdateTupleOperation) {
            InsertOrUpdateTupleOperation insertOrUpdateTuple = (InsertOrUpdateTupleOperation)operation;
            gridDialectOperation = new InsertOrUpdateTupleImpl(insertOrUpdateTuple.getEntityKey(), insertOrUpdateTuple.getTuplePointer().getTuple());
        } else if (operation instanceof RemoveTupleOperation) {
            RemoveTupleOperation removeTuple = (RemoveTupleOperation)operation;
            gridDialectOperation = new RemoveTupleImpl(removeTuple.getEntityKey());
        } else if (operation instanceof InsertOrUpdateAssociationOperation) {
            InsertOrUpdateAssociationOperation insertOrUpdateAssociationOperation = (InsertOrUpdateAssociationOperation)operation;
            gridDialectOperation = new InsertOrUpdateAssociationImpl(insertOrUpdateAssociationOperation.getAssociationKey(), insertOrUpdateAssociationOperation.getAssociation());
        } else if (operation instanceof RemoveAssociationOperation) {
            RemoveAssociationOperation removeAssociationOperation = (RemoveAssociationOperation)operation;
            gridDialectOperation = new RemoveAssociationImpl(removeAssociationOperation.getAssociationKey());
        } else {
            throw new IllegalStateException("Unsupported operation " + operation);
        }
        return gridDialectOperation;
    }

    @Override
    public Tuple createTuple(EntityKey key, OperationContext operationContext) {
        Tuple tuple = null;
        CreateTupleWithKeyImpl createTupleWithKey = new CreateTupleWithKeyImpl(key);
        try {
            tuple = super.createTuple(key, operationContext);
        }
        catch (Exception e) {
            this.handleException(createTupleWithKey, e);
        }
        this.handleAppliedOperation(createTupleWithKey);
        return tuple;
    }

    @Override
    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        RemoveTupleImpl removeTuple = new RemoveTupleImpl(key);
        try {
            super.removeTuple(key, tupleContext);
        }
        catch (Exception e) {
            this.handleException(removeTuple, e);
        }
        this.handleAppliedOperation(removeTuple);
    }

    @Override
    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        Association association = null;
        CreateAssociationWithKeyImpl createAssociationWithKey = new CreateAssociationWithKeyImpl(key);
        try {
            association = super.createAssociation(key, associationContext);
        }
        catch (Exception e) {
            this.handleException(createAssociationWithKey, e);
        }
        this.handleAppliedOperation(createAssociationWithKey);
        return association;
    }

    @Override
    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        InsertOrUpdateAssociationImpl insertOrUpdateAssociation = new InsertOrUpdateAssociationImpl(key, association);
        try {
            super.insertOrUpdateAssociation(key, association, associationContext);
        }
        catch (Exception e) {
            this.handleException(insertOrUpdateAssociation, e);
        }
        this.handleAppliedOperation(insertOrUpdateAssociation);
    }

    @Override
    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        RemoveAssociationImpl removeAssociation = new RemoveAssociationImpl(key);
        try {
            super.removeAssociation(key, associationContext);
        }
        catch (Exception e) {
            this.handleException(removeAssociation, e);
        }
        this.handleAppliedOperation(removeAssociation);
    }

    @Override
    public Tuple createTuple(EntityKeyMetadata entityKeyMetadata, OperationContext operationContext) {
        Tuple tuple = null;
        CreateTupleImpl createTuple = new CreateTupleImpl(entityKeyMetadata);
        try {
            tuple = super.createTuple(entityKeyMetadata, operationContext);
        }
        catch (Exception e) {
            this.handleException(createTuple, e);
        }
        this.handleAppliedOperation(createTuple);
        return tuple;
    }

    @Override
    public void insertTuple(EntityKeyMetadata entityKeyMetadata, Tuple tuple, TupleContext tupleContext) {
        InsertTupleImpl insertTuple = new InsertTupleImpl(entityKeyMetadata, tuple);
        try {
            super.insertTuple(entityKeyMetadata, tuple, tupleContext);
        }
        catch (Exception e) {
            this.handleException(insertTuple, e);
        }
        this.handleAppliedOperation(insertTuple);
    }

    @Override
    public boolean updateTupleWithOptimisticLock(EntityKey entityKey, Tuple oldLockState, Tuple tuple, TupleContext tupleContext) {
        UpdateTupleWithOptimisticLockImpl updateTupleWithOptimisticLock = new UpdateTupleWithOptimisticLockImpl(entityKey, oldLockState, tuple);
        boolean success = false;
        try {
            success = super.updateTupleWithOptimisticLock(entityKey, oldLockState, tuple, tupleContext);
        }
        catch (Exception e) {
            this.handleException(updateTupleWithOptimisticLock, e);
        }
        return success;
    }

    public void onUpdateTupleWithOptimisticLockSuccess(EntityKey entityKey, Tuple oldLockState, Tuple tuple) {
        this.handleAppliedOperation(new UpdateTupleWithOptimisticLockImpl(entityKey, oldLockState, tuple));
    }

    public void onUpdateTupleWithOptimisticLockFailure(EntityKey entityKey, Tuple oldLockState, Tuple tuple, Exception e) {
        this.handleException(new UpdateTupleWithOptimisticLockImpl(entityKey, oldLockState, tuple), e);
    }

    @Override
    public boolean removeTupleWithOptimisticLock(EntityKey entityKey, Tuple oldLockState, TupleContext tupleContext) {
        RemoveTupleWithOptimisticLockImpl removeTupleWithOptimisticLock = new RemoveTupleWithOptimisticLockImpl(entityKey, oldLockState);
        boolean success = false;
        try {
            success = super.removeTupleWithOptimisticLock(entityKey, oldLockState, tupleContext);
        }
        catch (Exception e) {
            this.handleException(removeTupleWithOptimisticLock, e);
        }
        return success;
    }

    public void onRemoveTupleWithOptimisticLockSuccess(EntityKey entityKey, Tuple oldLockState) {
        this.handleAppliedOperation(new RemoveTupleWithOptimisticLockImpl(entityKey, oldLockState));
    }

    public void onRemoveTupleWithOptimisticLockFailure(EntityKey entityKey, Tuple oldLockState, Exception e) {
        this.handleException(new RemoveTupleWithOptimisticLockImpl(entityKey, oldLockState), e);
    }

    private void handleAppliedOperation(GridDialectOperation operation) {
        this.getOperationCollector().addAppliedOperation(operation);
    }

    private void handleException(GridDialectOperation operation, Exception e) {
        ErrorHandlingStrategy result = this.getOperationCollector().onFailedOperation(operation, e);
        if (result == ErrorHandlingStrategy.ABORT) {
            Exceptions.sneakyThrow(e);
        }
    }

    private OperationCollector getOperationCollector() {
        return this.eventContext.get(OperationCollector.class);
    }
}

