/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public enum DatastoreProviderType {
    MAP("org.hibernate.ogm.datastore.map.impl.MapDatastoreProvider"),
    INFINISPAN("org.hibernate.ogm.datastore.infinispan.impl.InfinispanEmbeddedDatastoreProvider"),
    INFINISPAN_EMBEDDED("org.hibernate.ogm.datastore.infinispan.impl.InfinispanEmbeddedDatastoreProvider"),
    INFINISPAN_REMOTE("org.hibernate.ogm.datastore.infinispanremote.impl.InfinispanRemoteDatastoreProvider"),
    MONGODB("org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider"),
    NEO4J_BOLT("org.hibernate.ogm.datastore.neo4j.remote.bolt.impl.BoltNeo4jDatastoreProvider"),
    NEO4J_HTTP("org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jDatastoreProvider"),
    NEO4J_EMBEDDED("org.hibernate.ogm.datastore.neo4j.embedded.impl.EmbeddedNeo4jDatastoreProvider");

    private static final Log log;
    private String datastoreProviderClassName;

    private DatastoreProviderType(String datastoreProviderClassName) {
        this.datastoreProviderClassName = datastoreProviderClassName;
    }

    public String getDatastoreProviderClassName() {
        return this.datastoreProviderClassName;
    }

    public static boolean isShortName(String name) {
        for (DatastoreProviderType provider : DatastoreProviderType.values()) {
            if (!provider.name().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static DatastoreProviderType byShortName(String shortName) {
        if ("infinispan".equalsIgnoreCase(shortName)) {
            log.usingDeprecatedDatastoreProviderName("infinispan", "infinispan_embedded");
        }
        return DatastoreProviderType.valueOf(shortName.toUpperCase());
    }

    static {
        log = LoggerFactory.make(MethodHandles.lookup());
    }
}

