/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.batch.spi;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.hibernate.ogm.dialect.batch.spi.GroupableEntityOperation;
import org.hibernate.ogm.dialect.batch.spi.GroupedChangesToEntityOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.Operation;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class OperationsQueue {
    public static final OperationsQueue CLOSED_QUEUE = new OperationsQueue(){

        @Override
        public boolean isClosed() {
            return true;
        }
    };
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final Queue<Operation> operations = new LinkedList<Operation>();
    private final Map<EntityKey, GroupedChangesToEntityOperation> groupedOperations = new HashMap<EntityKey, GroupedChangesToEntityOperation>();
    private final Set<EntityKey> insertionQueue = new HashSet<EntityKey>();
    private boolean closed = false;

    public void add(Operation operation) {
        this.validate();
        log.debugf("Add batched operation %1$s", operation);
        if (operation instanceof InsertOrUpdateTupleOperation) {
            this.addInsertOrUpdateTupleOperation((InsertOrUpdateTupleOperation)operation);
        } else if (operation instanceof GroupableEntityOperation) {
            this.addGroupableEntityOperation((GroupableEntityOperation)operation);
        } else {
            this.addOperation(operation);
        }
    }

    private void addInsertOrUpdateTupleOperation(InsertOrUpdateTupleOperation operation) {
        this.addGroupableEntityOperation(operation);
        this.insertionQueue.add(operation.getEntityKey());
    }

    private void addGroupableEntityOperation(GroupableEntityOperation operation) {
        this.validate();
        GroupedChangesToEntityOperation groupedOperation = this.getOrCreateGroupedChangesOnEntityOperation(operation.getEntityKey());
        groupedOperation.addOperation(operation);
    }

    private void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    private GroupedChangesToEntityOperation getOrCreateGroupedChangesOnEntityOperation(EntityKey entityKey) {
        GroupedChangesToEntityOperation groupedOperation = this.groupedOperations.get(entityKey);
        if (groupedOperation == null) {
            groupedOperation = new GroupedChangesToEntityOperation(entityKey);
            this.groupedOperations.put(entityKey, groupedOperation);
            this.addOperation(groupedOperation);
        }
        return this.groupedOperations.get(entityKey);
    }

    private void validate() {
        if (this.isClosed()) {
            throw log.closedOperationQueue();
        }
    }

    public Operation poll() {
        this.validate();
        return this.operations.poll();
    }

    public void clear() {
        this.groupedOperations.clear();
        this.operations.clear();
        this.insertionQueue.clear();
    }

    public void close() {
        this.clear();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isInTheInsertionQueue(EntityKey key) {
        return this.insertionQueue.contains(key);
    }

    public int size() {
        return this.operations.size();
    }
}

