/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.eventstate.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.compensation.impl.ErrorHandlerEnabledTransactionCoordinatorDecorator;
import org.hibernate.ogm.compensation.impl.OperationCollector;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.eventstate.impl.EventStateLifecycle;
import org.hibernate.ogm.dialect.impl.BatchOperationsDelegator;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.service.spi.ServiceRegistryImplementor;

class EventStateLifecycles {
    public static final EventStateLifecycles INSTANCE = new EventStateLifecycles();
    private final Map<Class<?>, EventStateLifecycle<?>> lifecycles;

    private EventStateLifecycles() {
        HashMap<Class, EventStateLifecycle> lifecycles = new HashMap<Class, EventStateLifecycle>();
        lifecycles.put(OperationCollector.class, OperationCollectorLifecycle.INSTANCE);
        lifecycles.put(OperationsQueue.class, OperationsQueueLifecycle.INSTANCE);
        this.lifecycles = Collections.unmodifiableMap(lifecycles);
    }

    public Map<Class<?>, EventStateLifecycle<?>> getEnabledLifecycles(ServiceRegistryImplementor serviceRegistry) {
        HashMap enabledLifecycles = new HashMap();
        for (Map.Entry<Class<?>, EventStateLifecycle<?>> lifecycle : this.lifecycles.entrySet()) {
            if (!lifecycle.getValue().mustBeEnabled(serviceRegistry)) continue;
            enabledLifecycles.put(lifecycle.getKey(), lifecycle.getValue());
        }
        return enabledLifecycles;
    }

    private static class OperationsQueueLifecycle
    implements EventStateLifecycle<OperationsQueue> {
        private static EventStateLifecycle<?> INSTANCE = new OperationsQueueLifecycle();

        private OperationsQueueLifecycle() {
        }

        @Override
        public boolean mustBeEnabled(ServiceRegistryImplementor serviceRegistry) {
            GridDialect gridDialect = (GridDialect)serviceRegistry.getService(GridDialect.class);
            BatchOperationsDelegator batchDelegator = GridDialects.getDelegateOrNull(gridDialect, BatchOperationsDelegator.class);
            return batchDelegator != null;
        }

        @Override
        public OperationsQueue create(SessionImplementor session) {
            return new OperationsQueue();
        }

        @Override
        public void onFinish(OperationsQueue operationsQueue, SessionImplementor session) {
            GridDialect gridDialect = (GridDialect)session.getFactory().getServiceRegistry().getService(GridDialect.class);
            if (operationsQueue.size() > 0) {
                GridDialects.getDelegateOrNull(gridDialect, BatchOperationsDelegator.class).executeBatch(operationsQueue);
            }
            operationsQueue.close();
        }
    }

    private static class OperationCollectorLifecycle
    implements EventStateLifecycle<OperationCollector> {
        private static EventStateLifecycle<?> INSTANCE = new OperationCollectorLifecycle();

        private OperationCollectorLifecycle() {
        }

        @Override
        public boolean mustBeEnabled(ServiceRegistryImplementor serviceRegistry) {
            return ((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSettings().containsKey("hibernate.ogm.error_handler");
        }

        @Override
        public OperationCollector create(SessionImplementor session) {
            return ((ErrorHandlerEnabledTransactionCoordinatorDecorator)session.getTransactionCoordinator()).getOperationCollector();
        }

        @Override
        public void onFinish(OperationCollector state, SessionImplementor session) {
        }
    }
}

