/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.dialect.batch.spi.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.spi.GroupingByEntityDialect;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.identity.spi.IdentityColumnAwareGridDialect;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.optimisticlock.spi.OptimisticLockingAwareGridDialect;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.dialect.query.spi.QueryParameters;
import org.hibernate.ogm.dialect.query.spi.QueryableGridDialect;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.SessionFactoryLifecycleAwareDialect;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.util.impl.Contracts;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.Type;

public class ForwardingGridDialect<T extends Serializable>
implements GridDialect,
BatchableGridDialect,
SessionFactoryLifecycleAwareDialect,
IdentityColumnAwareGridDialect,
QueryableGridDialect<T>,
OptimisticLockingAwareGridDialect,
Configurable,
ServiceRegistryAwareService,
MultigetGridDialect,
GroupingByEntityDialect {
    private final GridDialect gridDialect;
    private final BatchableGridDialect batchableGridDialect;
    private final GroupingByEntityDialect groupingByEntityGridDialect;
    private final QueryableGridDialect<T> queryableGridDialect;
    private final SessionFactoryLifecycleAwareDialect sessionFactoryAwareDialect;
    private final IdentityColumnAwareGridDialect identityColumnAwareGridDialect;
    private final OptimisticLockingAwareGridDialect optimisticLockingAwareGridDialect;
    private final MultigetGridDialect multigetGridDialect;

    public ForwardingGridDialect(GridDialect gridDialect) {
        Contracts.assertParameterNotNull(gridDialect, "gridDialect");
        this.gridDialect = gridDialect;
        this.batchableGridDialect = GridDialects.getDialectFacetOrNull(gridDialect, BatchableGridDialect.class);
        this.groupingByEntityGridDialect = GridDialects.getDialectFacetOrNull(gridDialect, GroupingByEntityDialect.class);
        this.queryableGridDialect = GridDialects.getDialectFacetOrNull(gridDialect, QueryableGridDialect.class);
        this.sessionFactoryAwareDialect = GridDialects.getDialectFacetOrNull(gridDialect, SessionFactoryLifecycleAwareDialect.class);
        this.identityColumnAwareGridDialect = GridDialects.getDialectFacetOrNull(gridDialect, IdentityColumnAwareGridDialect.class);
        this.optimisticLockingAwareGridDialect = GridDialects.getDialectFacetOrNull(gridDialect, OptimisticLockingAwareGridDialect.class);
        this.multigetGridDialect = GridDialects.getDialectFacetOrNull(gridDialect, MultigetGridDialect.class);
    }

    public GridDialect getGridDialect() {
        return this.gridDialect;
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        return this.gridDialect.getLockingStrategy(lockable, lockMode);
    }

    @Override
    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        return this.gridDialect.getTuple(key, operationContext);
    }

    @Override
    public Tuple createTuple(EntityKey key, OperationContext operationContext) {
        return this.gridDialect.createTuple(key, operationContext);
    }

    @Override
    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) {
        this.gridDialect.insertOrUpdateTuple(key, tuplePointer, tupleContext);
    }

    @Override
    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        this.gridDialect.removeTuple(key, tupleContext);
    }

    @Override
    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        return this.gridDialect.getAssociation(key, associationContext);
    }

    @Override
    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        return this.gridDialect.createAssociation(key, associationContext);
    }

    @Override
    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        this.gridDialect.insertOrUpdateAssociation(key, association, associationContext);
    }

    @Override
    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        this.gridDialect.removeAssociation(key, associationContext);
    }

    @Override
    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return this.gridDialect.isStoredInEntityStructure(associationKeyMetadata, associationTypeContext);
    }

    @Override
    public Number nextValue(NextValueRequest request) {
        return this.gridDialect.nextValue(request);
    }

    @Override
    public boolean supportsSequences() {
        return this.gridDialect.supportsSequences();
    }

    @Override
    public GridType overrideType(Type type) {
        return this.gridDialect.overrideType(type);
    }

    @Override
    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        this.gridDialect.forEachTuple(consumer, tupleTypeContext, entityKeyMetadata);
    }

    @Override
    public DuplicateInsertPreventionStrategy getDuplicateInsertPreventionStrategy(EntityKeyMetadata entityKeyMetadata) {
        return this.gridDialect.getDuplicateInsertPreventionStrategy(entityKeyMetadata);
    }

    @Override
    public void executeBatch(OperationsQueue queue) {
        if (this.batchableGridDialect != null) {
            this.batchableGridDialect.executeBatch(queue);
        } else if (this.groupingByEntityGridDialect != null) {
            this.groupingByEntityGridDialect.executeBatch(queue);
        }
    }

    @Override
    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<T> query, QueryParameters queryParameters, TupleContext tupleContext) {
        return this.queryableGridDialect.executeBackendQuery(query, queryParameters, tupleContext);
    }

    @Override
    public int executeBackendUpdateQuery(BackendQuery<T> query, QueryParameters queryParameters, TupleContext tupleContext) {
        return this.queryableGridDialect.executeBackendUpdateQuery(query, queryParameters, tupleContext);
    }

    @Override
    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return this.queryableGridDialect.getParameterMetadataBuilder();
    }

    @Override
    public T parseNativeQuery(String nativeQuery) {
        return this.queryableGridDialect.parseNativeQuery(nativeQuery);
    }

    @Override
    public boolean updateTupleWithOptimisticLock(EntityKey entityKey, Tuple oldLockState, Tuple tuple, TupleContext tupleContext) {
        return this.optimisticLockingAwareGridDialect.updateTupleWithOptimisticLock(entityKey, oldLockState, tuple, tupleContext);
    }

    @Override
    public boolean removeTupleWithOptimisticLock(EntityKey entityKey, Tuple oldLockState, TupleContext tupleContext) {
        return this.optimisticLockingAwareGridDialect.removeTupleWithOptimisticLock(entityKey, oldLockState, tupleContext);
    }

    @Override
    public void sessionFactoryCreated(SessionFactoryImplementor sessionFactoryImplementor) {
        this.sessionFactoryAwareDialect.sessionFactoryCreated(sessionFactoryImplementor);
    }

    @Override
    public Tuple createTuple(EntityKeyMetadata entityKeyMetadata, OperationContext operationContext) {
        return this.identityColumnAwareGridDialect.createTuple(entityKeyMetadata, operationContext);
    }

    @Override
    public void insertTuple(EntityKeyMetadata entityKeyMetadata, Tuple tuple, TupleContext tupleContext) {
        this.identityColumnAwareGridDialect.insertTuple(entityKeyMetadata, tuple, tupleContext);
    }

    @Override
    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        return this.multigetGridDialect.getTuples(keys, tupleContext);
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        if (this.gridDialect instanceof ServiceRegistryAwareService) {
            ((ServiceRegistryAwareService)this.gridDialect).injectServices(serviceRegistry);
        }
    }

    public void configure(Map configurationValues) {
        if (this.gridDialect instanceof Configurable) {
            ((Configurable)this.gridDialect).configure(configurationValues);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" -> ");
        GridDialect delegate = this.gridDialect;
        while (delegate instanceof ForwardingGridDialect) {
            sb.append(delegate.getClass().getSimpleName());
            sb.append(" -> ");
            delegate = ((ForwardingGridDialect)delegate).getGridDialect();
        }
        sb.append(delegate.getClass().getSimpleName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void flushPendingOperations(EntityKey entityKey, TupleContext tupleContext) {
        this.groupingByEntityGridDialect.flushPendingOperations(entityKey, tupleContext);
    }

    @Override
    public boolean usesNavigationalInformationForInverseSideOfAssociations() {
        return this.gridDialect.usesNavigationalInformationForInverseSideOfAssociations();
    }
}

