/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import java.lang.invoke.MethodHandles;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.hibernate.Criteria;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionDelegatorBaseImpl;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.jdbc.Work;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.datastore.spi.DatastoreConfiguration;
import org.hibernate.ogm.engine.spi.OgmSessionFactoryImplementor;
import org.hibernate.ogm.exception.NotSupportedException;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryImpl;
import org.hibernate.ogm.hibernatecore.impl.OgmSharedSessionBuilderDelegator;
import org.hibernate.ogm.options.navigation.GlobalContext;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.query.Query;
import org.hibernate.query.spi.ScrollableResultsImplementor;

public class OgmSessionImpl
extends SessionDelegatorBaseImpl
implements OgmSession,
EventSource {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final OgmSessionFactoryImpl factory;

    public OgmSessionImpl(OgmSessionFactory factory, EventSource delegate) {
        super((SessionImplementor)delegate);
        this.factory = (OgmSessionFactoryImpl)factory;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    @Override
    public OgmSessionFactoryImplementor getSessionFactory() {
        return this.factory;
    }

    public Transaction getTransaction() {
        return this.delegate.accessTransaction();
    }

    public Criteria createCriteria(Class persistentClass) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Criteria createCriteria(String entityName) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Criteria createCriteria(String entityName, String alias) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public ScrollableResultsImplementor scroll(Criteria criteria, ScrollMode scrollMode) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        throw new NotSupportedException("OGM-24", "filters are not supported yet");
    }

    public Filter enableFilter(String filterName) {
        throw new NotSupportedException("OGM-25", "filters are not supported yet");
    }

    public void disableFilter(String filterName) {
        throw new NotSupportedException("OGM-25", "filters are not supported yet");
    }

    public void doWork(Work work) throws HibernateException {
        throw new IllegalStateException("Hibernate OGM does not support SQL Connections hence no Work");
    }

    public ProcedureCall getNamedProcedureCall(String name) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public ProcedureCall createStoredProcedureCall(String procedureName) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, Class ... resultClasses) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public SharedSessionBuilder sessionWithOptions() {
        return new OgmSharedSessionBuilderDelegator(this.delegate.sessionWithOptions(), this.factory);
    }

    public <G extends GlobalContext<?, ?>, D extends DatastoreConfiguration<G>> G configureDatastore(Class<D> datastoreType) {
        throw new UnsupportedOperationException("OGM-343 Session specific options are not currently supported");
    }

    public void removeOrphanBeforeUpdates(String entityName, Object child) {
        this.delegate.removeOrphanBeforeUpdates(entityName, child);
    }

    public NaturalIdLoadAccess byNaturalId(Class entityClass) {
        throw new UnsupportedOperationException("OGM-589 - Natural id look-ups are not yet supported");
    }

    public NaturalIdLoadAccess byNaturalId(String entityName) {
        throw new UnsupportedOperationException("OGM-589 - Natural id look-ups are not yet supported");
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(Class entityClass) {
        throw new UnsupportedOperationException("OGM-589 - Natural id look-ups are not yet supported");
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(String entityName) {
        throw new UnsupportedOperationException("OGM-589 - Natural id look-ups are not yet supported");
    }

    public <T> T unwrap(Class<T> clazz) {
        this.checkOpen();
        if (Session.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        if (SessionImplementor.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        if (SharedSessionContractImplementor.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        if (OgmSession.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        if (EntityManager.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        throw new PersistenceException("Hibernate OGM cannot unwrap " + clazz);
    }
}

