/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.massindex.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.ogm.loader.impl.OgmLoadingContext;
import org.hibernate.ogm.loader.impl.TupleBasedEntityLoader;
import org.hibernate.ogm.massindex.impl.Helper;
import org.hibernate.ogm.massindex.impl.SessionAwareRunnable;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.spi.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.hcore.util.impl.HibernateHelper;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.interceptor.IndexingOverride;
import org.hibernate.search.orm.loading.impl.HibernateSessionLoadingInitializer;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.logging.impl.Log;

public class TupleIndexer
implements SessionAwareRunnable {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final SessionFactoryImplementor sessionFactory;
    private final IndexedTypeMap<EntityIndexBinding> entityIndexBindings;
    private final MassIndexerProgressMonitor monitor;
    private final CacheMode cacheMode;
    private final BatchBackend backend;
    private final ErrorHandler errorHandler;
    private final IndexedTypeIdentifier indexedTypeIdentifier;
    private final ServiceManager serviceManager;
    private final String tenantId;

    public TupleIndexer(IndexedTypeIdentifier indexedTypeIdentifier, MassIndexerProgressMonitor monitor, SessionFactoryImplementor sessionFactory, ExtendedSearchIntegrator searchIntegrator, CacheMode cacheMode, BatchBackend backend, ErrorHandler errorHandler, String tenantId) {
        this.indexedTypeIdentifier = indexedTypeIdentifier;
        this.monitor = monitor;
        this.sessionFactory = sessionFactory;
        this.cacheMode = cacheMode;
        this.backend = backend;
        this.errorHandler = errorHandler;
        this.tenantId = tenantId;
        this.entityIndexBindings = searchIntegrator.getIndexBindings();
        this.serviceManager = searchIntegrator.getServiceManager();
    }

    private void index(Session session, Object entity) {
        try {
            HibernateSessionLoadingInitializer sessionInitializer = new HibernateSessionLoadingInitializer((SessionImplementor)session);
            ContextualExceptionBridgeHelper contextualBridge = new ContextualExceptionBridgeHelper();
            session.buildLockRequest(LockOptions.NONE).lock(entity);
            this.index(entity, session, (InstanceInitializer)sessionInitializer, (ConversionContext)contextualBridge);
            this.monitor.documentsBuilt(1);
            session.clear();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void index(Object entity, Session session, InstanceInitializer sessionInitializer, ConversionContext conversionContext) throws InterruptedException {
        EntityIndexingInterceptor interceptor;
        Class clazz = HibernateHelper.getClass((Object)entity);
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)this.entityIndexBindings.get(clazz);
        if (entityIndexBinding != null && this.isNotSkippable(interceptor = entityIndexBinding.getEntityIndexingInterceptor(), entity)) {
            Serializable id = session.getIdentifier(entity);
            AddLuceneWork addWork = this.createAddLuceneWork(this.tenantId, entity, sessionInitializer, conversionContext, id, entityIndexBinding);
            this.backend.enqueueAsyncWork((LuceneWork)addWork);
        }
    }

    private AddLuceneWork createAddLuceneWork(String tenantIdentifier, Object entity, InstanceInitializer sessionInitializer, ConversionContext conversionContext, Serializable id, EntityIndexBinding entityIndexBinding) {
        DocumentBuilderIndexedEntity docBuilder = entityIndexBinding.getDocumentBuilder();
        String idInString = this.idInString(conversionContext, id, docBuilder.getTypeIdentifier(), docBuilder);
        return docBuilder.createAddWork(tenantIdentifier, docBuilder.getTypeIdentifier(), entity, id, idInString, sessionInitializer, conversionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String idInString(ConversionContext conversionContext, Serializable id, IndexedTypeIdentifier typeIdentifier, DocumentBuilderIndexedEntity docBuilder) {
        conversionContext.pushProperty(docBuilder.getIdPropertyName());
        try {
            String idInString;
            String string = idInString = conversionContext.setConvertedTypeId(typeIdentifier).twoWayConversionContext(docBuilder.getIdBridge()).objectToString((Object)id);
            return string;
        }
        finally {
            conversionContext.popProperty();
        }
    }

    private boolean isNotSkippable(EntityIndexingInterceptor interceptor, Object entity) {
        if (interceptor == null) {
            return true;
        }
        return !this.isSkippable(interceptor.onAdd(entity));
    }

    private boolean isSkippable(IndexingOverride indexingOverride) {
        switch (indexingOverride) {
            case REMOVE: 
            case SKIP: {
                return true;
            }
        }
        return false;
    }

    private Transaction beginTransaction(Session session) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Transaction transaction = Helper.getTransactionAndMarkForJoin(session, this.serviceManager);
        transaction.begin();
        return transaction;
    }

    private Session openSession(Session upperSession) {
        Session session = upperSession;
        if (upperSession == null) {
            session = this.sessionFactory.openSession();
        }
        this.initSession(session);
        return session;
    }

    private void initSession(Session session) {
        session.setFlushMode(FlushMode.MANUAL);
        session.setCacheMode(this.cacheMode);
        session.setDefaultReadOnly(true);
    }

    private void close(Session upperSession, Session session) {
        if (upperSession == null) {
            session.close();
        }
    }

    @Override
    public void run(Session upperSession, Tuple tuple) {
        if (upperSession == null) {
            this.runInNewTransaction(upperSession, tuple);
        } else {
            this.runIndexing(upperSession, tuple);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIndexing(Session upperSession, Tuple tuple) {
        this.initSession(upperSession);
        try {
            this.index(upperSession, this.entity(upperSession, tuple));
        }
        catch (Throwable e) {
            this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
        }
        finally {
            log.debug((Object)"finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInNewTransaction(Session upperSession, Tuple tuple) {
        Session session = this.openSession(upperSession);
        try {
            Transaction transaction = this.beginTransaction(session);
            this.index(session, this.entity(session, tuple));
            transaction.commit();
        }
        catch (Throwable e) {
            this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
        }
        finally {
            this.close(upperSession, session);
            log.debug((Object)"finished");
        }
    }

    private Object entity(Session session, Tuple tuple) {
        SessionImplementor sessionImplementor = (SessionImplementor)session;
        OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getMetamodel().entityPersister(this.indexedTypeIdentifier.getPojoType());
        TupleBasedEntityLoader loader = (TupleBasedEntityLoader)persister.getAppropriateLoader(LockOptions.READ, (SharedSessionContractImplementor)sessionImplementor);
        OgmLoadingContext ogmLoadingContext = new OgmLoadingContext();
        ogmLoadingContext.setTuples(Collections.singletonList(tuple));
        List<Object> entities = loader.loadEntitiesFromTuples((SharedSessionContractImplementor)sessionImplementor, LockOptions.NONE, ogmLoadingContext);
        return entities.get(0);
    }
}

