/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.navigation.impl;

import java.lang.annotation.ElementType;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import org.hibernate.ogm.options.navigation.EntityContext;
import org.hibernate.ogm.options.navigation.GlobalContext;
import org.hibernate.ogm.options.navigation.PropertyContext;
import org.hibernate.ogm.options.navigation.impl.AppendableConfigurationContext;
import org.hibernate.ogm.options.navigation.spi.ConfigurationContext;
import org.hibernate.ogm.options.spi.Option;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.ReflectionHelper;

public class ConfigurationContextImpl
implements ConfigurationContext {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final AppendableConfigurationContext allOptions;
    private Class<?> currentEntityType;
    private String currentPropertyName;

    public ConfigurationContextImpl(AppendableConfigurationContext appendableContext) {
        this.allOptions = appendableContext;
    }

    @Override
    public <V> void addGlobalOption(Option<?, V> option, V value) {
        this.allOptions.addGlobalOption(option, value);
    }

    @Override
    public <V> void addEntityOption(Option<?, V> option, V value) {
        this.allOptions.addEntityOption(this.currentEntityType, option, value);
    }

    @Override
    public <V> void addPropertyOption(Option<?, V> option, V value) {
        this.allOptions.addPropertyOption(this.currentEntityType, this.currentPropertyName, option, value);
    }

    public void configureEntity(Class<?> entityType) {
        this.currentEntityType = entityType;
    }

    public void configureProperty(String propertyName, ElementType elementType) {
        if (elementType != ElementType.FIELD && elementType != ElementType.METHOD) {
            throw log.getUnsupportedElementTypeException(elementType);
        }
        if (!ReflectionHelper.propertyExists(this.currentEntityType, propertyName, elementType)) {
            throw log.getPropertyDoesNotExistException(this.currentEntityType.getName(), propertyName, elementType);
        }
        this.currentPropertyName = propertyName;
    }

    @Override
    public <G extends GlobalContext<?, ?>> G createGlobalContext(Class<? extends G> globalContextImplType, Class<? extends EntityContext<?, ?>> entityContextImplType, Class<? extends PropertyContext<?, ?>> propertyContextImplType) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(globalContextImplType);
        proxyFactory.setFilter((MethodFilter)new EntityMethodFilter());
        try {
            return (G)((GlobalContext)proxyFactory.create(new Class[]{ConfigurationContext.class}, new Object[]{this}, (MethodHandler)new EntityOrPropertyMethodHandler(entityContextImplType, propertyContextImplType)));
        }
        catch (Exception e) {
            throw log.cannotCreateGlobalContextProxy(globalContextImplType, e);
        }
    }

    private <E extends EntityContext<?, ?>> E createEntityMappingContext(Class<? extends E> entityContextImplType, Class<? extends PropertyContext<?, ?>> propertyContextImplType) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(entityContextImplType);
        proxyFactory.setFilter((MethodFilter)new EntityOrPropertyMethodFilter());
        try {
            return (E)((EntityContext)proxyFactory.create(new Class[]{ConfigurationContext.class}, new Object[]{this}, (MethodHandler)new EntityOrPropertyMethodHandler(entityContextImplType, propertyContextImplType)));
        }
        catch (Exception e) {
            throw log.cannotCreateEntityContextProxy(entityContextImplType, e);
        }
    }

    private <P extends PropertyContext<?, ?>> P createPropertyMappingContext(Class<? extends EntityContext<?, ?>> entityContextImplType, Class<? extends P> propertyContextImplType) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(propertyContextImplType);
        proxyFactory.setFilter((MethodFilter)new EntityOrPropertyMethodFilter());
        try {
            return (P)((PropertyContext)proxyFactory.create(new Class[]{ConfigurationContext.class}, new Object[]{this}, (MethodHandler)new EntityOrPropertyMethodHandler(entityContextImplType, propertyContextImplType)));
        }
        catch (Exception e) {
            throw log.cannotCreateEntityContextProxy(propertyContextImplType, e);
        }
    }

    private final class EntityOrPropertyMethodFilter
    implements MethodFilter {
        private EntityOrPropertyMethodFilter() {
        }

        public boolean isHandled(Method m) {
            return m.getName().equals("entity") && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == Class.class || m.getName().equals("property") && m.getParameterTypes().length == 2 && m.getParameterTypes()[0] == String.class && m.getParameterTypes()[1] == ElementType.class;
        }
    }

    private final class EntityMethodFilter
    implements MethodFilter {
        private EntityMethodFilter() {
        }

        public boolean isHandled(Method m) {
            return m.getName().equals("entity") && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == Class.class;
        }
    }

    private final class EntityOrPropertyMethodHandler
    implements MethodHandler {
        private final Class<? extends EntityContext<?, ?>> entityContextImplType;
        private final Class<? extends PropertyContext<?, ?>> propertyContextImplType;

        private EntityOrPropertyMethodHandler(Class<? extends EntityContext<?, ?>> entityContextImplType, Class<? extends PropertyContext<?, ?>> propertyContextImplType) {
            this.entityContextImplType = entityContextImplType;
            this.propertyContextImplType = propertyContextImplType;
        }

        public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
            if (thisMethod.getName().equals("entity")) {
                ConfigurationContextImpl.this.configureEntity((Class)args[0]);
                return ConfigurationContextImpl.this.createEntityMappingContext(this.entityContextImplType, this.propertyContextImplType);
            }
            ConfigurationContextImpl.this.configureProperty((String)args[0], (ElementType)((Object)args[1]));
            return ConfigurationContextImpl.this.createPropertyMappingContext(this.entityContextImplType, this.propertyContextImplType);
        }
    }
}

