/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.service.impl.DefaultSchemaInitializationContext;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class SchemaDefiningObserver
implements SessionFactoryObserver {
    private final Database database;

    public SchemaDefiningObserver(Metadata metadata) {
        this.database = metadata.getDatabase();
    }

    public void sessionFactoryCreated(SessionFactory factory) {
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)factory;
        ServiceRegistryImplementor registry = sessionFactoryImplementor.getServiceRegistry();
        SchemaDefiner schemaInitializer = (SchemaDefiner)registry.getService(SchemaDefiner.class);
        DefaultSchemaInitializationContext context = new DefaultSchemaInitializationContext(this.database, sessionFactoryImplementor);
        schemaInitializer.validateMapping(context);
        schemaInitializer.initializeSchema(context);
    }

    public void sessionFactoryClosed(SessionFactory factory) {
    }
}

