/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.configurationreader.spi;

import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cfg.Configuration;
import org.hibernate.ogm.util.configurationreader.impl.SimplePropertyReaderContext;
import org.hibernate.ogm.util.configurationreader.spi.PropertyReaderContext;

public class ConfigurationPropertyReader {
    private final Map<?, ?> properties;
    private final ClassLoaderService classLoaderService;

    public ConfigurationPropertyReader(Configuration configuration) {
        this(configuration.getProperties(), null);
    }

    public ConfigurationPropertyReader(Map<?, ?> properties) {
        this(properties, null);
    }

    public ConfigurationPropertyReader(Configuration configuration, ClassLoaderService classLoaderService) {
        this(configuration.getProperties(), classLoaderService);
    }

    public ConfigurationPropertyReader(Map<?, ?> properties, ClassLoaderService classLoaderService) {
        this.properties = properties;
        this.classLoaderService = classLoaderService;
    }

    public <T> PropertyReaderContext<T> property(String propertyName, Class<T> targetType) {
        return new SimplePropertyReaderContext<T>(this.classLoaderService, this.properties, propertyName, targetType);
    }
}

