/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import org.hibernate.Session;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.ogm.dialect.impl.EmptyTransactionContext;
import org.hibernate.ogm.dialect.impl.IdentifiableDriver;
import org.hibernate.ogm.dialect.impl.TransactionContextImpl;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;

public final class TransactionContextHelper {
    private TransactionContextHelper() {
    }

    public static TransactionContext transactionContext(Session session) {
        return TransactionContextHelper.transactionContext((SharedSessionContractImplementor)session);
    }

    public static TransactionContext transactionContext(SharedSessionContractImplementor session) {
        TransactionCoordinator.TransactionDriver driver;
        TransactionCoordinator transactionCoordinator = session.getTransactionCoordinator();
        if (transactionCoordinator != null && transactionCoordinator.getTransactionDriverControl() != null && (driver = transactionCoordinator.getTransactionDriverControl()) instanceof IdentifiableDriver) {
            return new TransactionContextImpl((IdentifiableDriver)driver);
        }
        return EmptyTransactionContext.INSTANCE;
    }
}

