/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.boot.impl;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.ogm.boot.impl.OgmConfigurationServiceImpl;
import org.hibernate.ogm.cfg.impl.HibernateSearchIntegration;
import org.hibernate.ogm.datastore.impl.DatastoreProviderInitiator;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManagerInitiator;
import org.hibernate.ogm.dialect.impl.GridDialectInitiator;
import org.hibernate.ogm.dialect.impl.IdentityColumnAwareGridDialectInitiator;
import org.hibernate.ogm.dialect.impl.MultigetGridDialectInitiator;
import org.hibernate.ogm.dialect.impl.OgmDialectFactoryInitiator;
import org.hibernate.ogm.dialect.impl.OptimisticLockingAwareGridDialectInitiator;
import org.hibernate.ogm.dialect.impl.QueryableGridDialectInitiator;
import org.hibernate.ogm.dialect.impl.StoredProcedureGridDialectInitiator;
import org.hibernate.ogm.jdbc.impl.OgmConnectionProviderInitiator;
import org.hibernate.ogm.jpa.impl.OgmMutableIdentifierGeneratorFactoryInitiator;
import org.hibernate.ogm.jpa.impl.OgmPersisterClassResolverInitiator;
import org.hibernate.ogm.options.navigation.impl.OptionsServiceInitiator;
import org.hibernate.ogm.query.impl.OgmQueryTranslatorFactoryInitiator;
import org.hibernate.ogm.service.impl.OgmConfigurationService;
import org.hibernate.ogm.service.impl.OgmJdbcServicesInitiator;
import org.hibernate.ogm.service.impl.OgmSessionFactoryServiceRegistryFactoryInitiator;
import org.hibernate.ogm.transaction.impl.OgmJtaPlatformInitiator;
import org.hibernate.ogm.transaction.impl.OgmTransactionCoordinatorBuilderInitiator;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.service.Service;
import org.hibernate.service.spi.ServiceContributor;

public class OgmServiceRegistryInitializer
implements ServiceContributor {
    public void contribute(StandardServiceRegistryBuilder serviceRegistryBuilder) {
        Map settings = serviceRegistryBuilder.getSettings();
        boolean isOgmEnabled = this.isOgmEnabled(settings);
        serviceRegistryBuilder.addService(OgmConfigurationService.class, (Service)new OgmConfigurationServiceImpl(isOgmEnabled));
        if (!isOgmEnabled) {
            return;
        }
        if (!settings.containsKey("hibernate.auto_quote_keyword")) {
            serviceRegistryBuilder.applySetting("hibernate.auto_quote_keyword", (Object)false);
        }
        HibernateSearchIntegration.resetProperties(serviceRegistryBuilder);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmQueryTranslatorFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmSessionFactoryServiceRegistryFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmPersisterClassResolverInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmConnectionProviderInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmDialectFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmTransactionCoordinatorBuilderInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmJtaPlatformInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmJdbcServicesInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)DatastoreProviderInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OptionsServiceInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmMutableIdentifierGeneratorFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)EventContextManagerInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)GridDialectInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)QueryableGridDialectInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)IdentityColumnAwareGridDialectInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OptimisticLockingAwareGridDialectInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)MultigetGridDialectInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)StoredProcedureGridDialectInitiator.INSTANCE);
    }

    private boolean isOgmEnabled(Map<?, ?> settings) {
        return new ConfigurationPropertyReader(settings).property("hibernate.ogm.enabled", Boolean.TYPE).withDefault(false).getValue();
    }
}

