/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.cfg.spi;

import org.hibernate.ogm.cfg.impl.HostParser;
import org.hibernate.ogm.cfg.spi.Hosts;
import org.hibernate.ogm.util.configurationreader.impl.Validators;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;

public abstract class DocumentStoreConfiguration {
    private static final String DEFAULT_HOST = "localhost";
    private final Hosts hosts;
    private final String databaseName;
    private final String username;
    private final String password;
    private final boolean createDatabase;

    public DocumentStoreConfiguration(ConfigurationPropertyReader propertyReader, int defaultPort) {
        String host = propertyReader.property("hibernate.ogm.datastore.host", String.class).withDefault(DEFAULT_HOST).getValue();
        Integer port = propertyReader.property("hibernate.ogm.datastore.port", Integer.class).withValidator(Validators.PORT).withDefault(null).getValue();
        this.hosts = HostParser.parse(host, port, defaultPort);
        this.databaseName = propertyReader.property("hibernate.ogm.datastore.database", String.class).required().getValue();
        this.username = propertyReader.property("hibernate.ogm.datastore.username", String.class).getValue();
        this.password = propertyReader.property("hibernate.ogm.datastore.password", String.class).getValue();
        this.createDatabase = propertyReader.property("hibernate.ogm.datastore.create_database", Boolean.TYPE).withDefault(false).getValue();
    }

    public Hosts getHosts() {
        return this.hosts;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isCreateDatabase() {
        return this.createDatabase;
    }
}

