/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.document.association.spi;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRow;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRowFactory;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.util.impl.CollectionHelper;

public class AssociationRows
implements AssociationSnapshot {
    private final Map<RowKey, AssociationRow<?>> rows;

    public AssociationRows(AssociationKey associationKey, Collection<?> wrapped, AssociationRowFactory associationRowFactory) {
        this.rows = CollectionHelper.newLinkedHashMap(wrapped.size());
        for (Object object : wrapped) {
            AssociationRow<?> row = associationRowFactory.createAssociationRow(associationKey, object);
            this.rows.put(row.getKey(), row);
        }
    }

    @Override
    public Tuple get(RowKey rowKey) {
        AssociationRow<?> row = this.rows.get(rowKey);
        return row != null ? new Tuple(row, Tuple.SnapshotType.UPDATE) : null;
    }

    @Override
    public boolean containsKey(RowKey rowKey) {
        return this.rows.containsKey(rowKey);
    }

    public Set<RowKey> getRowKeys() {
        return this.rows.keySet();
    }

    @Override
    public int size() {
        return this.rows.size();
    }
}

