/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.eventstate.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.ogm.dialect.eventstate.impl.EventStateLifecycle;
import org.hibernate.ogm.dialect.eventstate.impl.EventStateLifecycles;
import org.hibernate.service.Service;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class EventContextManager
implements Service,
ServiceRegistryAwareService {
    private final ThreadLocal<Map<Class<?>, Object>> stateHolder = new ThreadLocal();
    private Map<Class<?>, EventStateLifecycle<?>> enabledLifecycles;

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.enabledLifecycles = Collections.unmodifiableMap(EventStateLifecycles.INSTANCE.getEnabledLifecycles(serviceRegistry));
    }

    public static boolean isEventContextRequired(ServiceRegistryImplementor serviceRegistry) {
        return !EventStateLifecycles.INSTANCE.getEnabledLifecycles(serviceRegistry).isEmpty();
    }

    void onEventBegin(EventSource session) {
        HashMap stateMap = new HashMap();
        stateMap.put(SessionImplementor.class, session);
        for (Map.Entry<Class<?>, EventStateLifecycle<?>> lifecycle : this.enabledLifecycles.entrySet()) {
            Object value = lifecycle.getValue().create((SessionImplementor)session);
            stateMap.put(lifecycle.getKey(), value);
        }
        this.stateHolder.set(stateMap);
    }

    void onEventFinished() {
        Map<Class<?>, Object> states = this.stateHolder.get();
        if (states == null) {
            return;
        }
        SessionImplementor session = (SessionImplementor)states.get(SessionImplementor.class);
        for (Map.Entry<Class<?>, Object> state : states.entrySet()) {
            if (state.getValue() == session) continue;
            this.onFinish(state.getKey(), state.getValue(), session);
        }
        this.stateHolder.remove();
    }

    private <T> void onFinish(Class<T> stateType, Object state, SessionImplementor session) {
        Object typedState = state;
        this.getLifecycle(stateType).onFinish(typedState, session);
    }

    public <T> T get(Class<T> stateType) {
        Map<Class<?>, Object> states = this.getStates();
        T value = this.getState(states, stateType);
        if (value == null) {
            throw new IllegalArgumentException("Accessing state of type not enabled: " + stateType);
        }
        return value;
    }

    public boolean isActive() {
        return this.stateHolder.get() != null;
    }

    private Map<Class<?>, Object> getStates() {
        Map<Class<?>, Object> states = this.stateHolder.get();
        if (states == null) {
            throw new IllegalStateException("Must not access event cycle state if not within a supported event cycle (flush, auto-flush, persist)");
        }
        return states;
    }

    private <T> T getState(Map<Class<?>, Object> states, Class<T> stateType) {
        Object value = states.get(stateType);
        return (T)value;
    }

    private <T> EventStateLifecycle<T> getLifecycle(Class<T> stateType) {
        EventStateLifecycle<?> lifecycle = this.enabledLifecycles.get(stateType);
        return lifecycle;
    }
}

