/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import org.hibernate.ogm.dialect.batch.spi.GroupedChangesToEntityOperation;
import org.hibernate.ogm.dialect.batch.spi.GroupingByEntityDialect;
import org.hibernate.ogm.dialect.batch.spi.Operation;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.batch.spi.RemoveTupleOperation;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.spi.Association;

public abstract class AbstractGroupingByEntityDialect
extends BaseGridDialect
implements GroupingByEntityDialect {
    @Override
    public void executeBatch(OperationsQueue queue) {
        if (!queue.isClosed()) {
            Operation operation = queue.poll();
            while (operation != null) {
                if (operation instanceof GroupedChangesToEntityOperation) {
                    GroupedChangesToEntityOperation entityOperation = (GroupedChangesToEntityOperation)operation;
                    this.executeGroupedChangesToEntity(entityOperation);
                } else if (operation instanceof RemoveTupleOperation) {
                    RemoveTupleOperation removeTupleOperation = (RemoveTupleOperation)operation;
                    this.removeTuple(removeTupleOperation.getEntityKey(), removeTupleOperation.getTupleContext());
                } else {
                    throw new UnsupportedOperationException("Operation not supported: " + operation.getClass().getSimpleName());
                }
                operation = queue.poll();
            }
            queue.clear();
        }
    }

    @Override
    public void flushPendingOperations(EntityKey entityKey, TupleContext tupleContext) {
        this.executeBatch(tupleContext.getOperationsQueue());
    }

    @Override
    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) {
        throw new UnsupportedOperationException("Method not supported by GroupingByEntityDialect implementations");
    }

    @Override
    public void insertOrUpdateAssociation(AssociationKey associationKey, Association association, AssociationContext associationContext) {
        throw new UnsupportedOperationException("Method not supported by GroupingByEntityDialect implementations");
    }

    @Override
    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        throw new UnsupportedOperationException("Method not supported by GroupingByEntityDialect implementations");
    }

    protected abstract void executeGroupedChangesToEntity(GroupedChangesToEntityOperation var1);
}

