/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class ExceptionThrowingLockingStrategy
implements LockingStrategy {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final Class<? extends GridDialect> gridDialectClass;
    private final LockMode lockMode;

    public ExceptionThrowingLockingStrategy(GridDialect gridDialect, LockMode lockMode) {
        this.gridDialectClass = gridDialect.getClass();
        this.lockMode = lockMode;
    }

    public void lock(Serializable id, Object version, Object object, int timeout, SharedSessionContractImplementor session) throws StaleObjectStateException, LockingStrategyException {
        throw LOG.unsupportedLockMode(this.gridDialectClass, this.lockMode);
    }
}

