/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import org.hibernate.Session;
import org.hibernate.engine.spi.AbstractDelegatingSessionBuilderImplementor;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionOwner;
import org.hibernate.event.spi.EventSource;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.engine.spi.OgmSessionBuilderImplementor;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionImpl;
import org.hibernate.ogm.jpa.impl.OgmExceptionMapper;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.AfterCompletionAction;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.ExceptionMapper;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.ManagedFlushChecker;

public class OgmSessionBuilderDelegator
extends AbstractDelegatingSessionBuilderImplementor<OgmSessionBuilderImplementor>
implements OgmSessionBuilderImplementor {
    private final SessionBuilderImplementor builder;
    private final OgmSessionFactory factory;

    public OgmSessionBuilderDelegator(SessionBuilderImplementor sessionBuilder, OgmSessionFactory factory) {
        super(sessionBuilder);
        this.builder = sessionBuilder;
        this.factory = factory;
    }

    @Override
    public OgmSession openSession() {
        Session session = this.builder.openSession();
        return new OgmSessionImpl(this.factory, (EventSource)session);
    }

    public OgmSessionBuilderImplementor owner(SessionOwner sessionOwner) {
        if (sessionOwner.getExceptionMapper() != null) {
            sessionOwner = new OgmExceptionMapperSessionOwner(sessionOwner);
        }
        this.builder.owner(sessionOwner);
        return this;
    }

    private static abstract class ForwardingSessionOwner
    implements SessionOwner {
        private final SessionOwner delegate;

        public ForwardingSessionOwner(SessionOwner delegate) {
            this.delegate = delegate;
        }

        public boolean shouldAutoCloseSession() {
            return this.delegate.shouldAutoCloseSession();
        }

        public ExceptionMapper getExceptionMapper() {
            return this.delegate.getExceptionMapper();
        }

        public AfterCompletionAction getAfterCompletionAction() {
            return this.delegate.getAfterCompletionAction();
        }

        public ManagedFlushChecker getManagedFlushChecker() {
            return this.delegate.getManagedFlushChecker();
        }
    }

    private static class OgmExceptionMapperSessionOwner
    extends ForwardingSessionOwner {
        public OgmExceptionMapperSessionOwner(SessionOwner delegate) {
            super(delegate);
        }

        @Override
        public ExceptionMapper getExceptionMapper() {
            return new OgmExceptionMapper(super.getExceptionMapper());
        }
    }
}

