/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.SynchronizationType;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.spi.SessionFactoryDelegatingImpl;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.engine.spi.OgmSessionBuilderImplementor;
import org.hibernate.ogm.engine.spi.OgmSessionFactoryImplementor;
import org.hibernate.ogm.exception.NotSupportedException;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionBuilderDelegator;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionImpl;

public class OgmSessionFactoryImpl
extends SessionFactoryDelegatingImpl
implements OgmSessionFactoryImplementor {
    private static final IdentifierGenerator UUID_GENERATOR = UUIDGenerator.buildSessionFactoryUniqueIdentifierGenerator();
    private final String uuid;

    public OgmSessionFactoryImpl(SessionFactoryImplementor delegate) {
        super(delegate);
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryRegistry.INSTANCE.addSessionFactory(this.uuid, delegate.getName(), delegate.getSessionFactoryOptions().isSessionFactoryNameAlsoJndiName(), (SessionFactory)this, (JndiService)delegate.getServiceRegistry().getService(JndiService.class));
    }

    @Override
    public OgmSession openTemporarySession() throws HibernateException {
        return new OgmSessionImpl(this, (EventSource)this.delegate().openTemporarySession());
    }

    @Override
    public OgmSessionBuilderImplementor withOptions() {
        return new OgmSessionBuilderDelegator(this.delegate().withOptions(), this);
    }

    @Override
    public OgmSession openSession() throws HibernateException {
        Session session = this.delegate().openSession();
        return new OgmSessionImpl(this, (EventSource)session);
    }

    @Override
    public OgmSession getCurrentSession() throws HibernateException {
        Session session = this.delegate().getCurrentSession();
        return new OgmSessionImpl(this, (EventSource)session);
    }

    public StatelessSessionBuilder withStatelessOptions() {
        throw new NotSupportedException("OGM-18", "Stateless session is not implemented in OGM");
    }

    public StatelessSession openStatelessSession() {
        throw new NotSupportedException("OGM-18", "Stateless session is not implemented in OGM");
    }

    public StatelessSession openStatelessSession(Connection connection) {
        throw new NotSupportedException("OGM-18", "Stateless session is not implemented in OGM");
    }

    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryRegistry.ObjectFactoryImpl.class.getName(), null);
    }

    public EntityManager createEntityManager() {
        return new OgmSessionImpl(this, (EventSource)this.delegate().createEntityManager());
    }

    public EntityManager createEntityManager(Map map) {
        return new OgmSessionImpl(this, (EventSource)this.delegate().createEntityManager(map));
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return new OgmSessionImpl(this, (EventSource)this.delegate().createEntityManager(synchronizationType));
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return new OgmSessionImpl(this, (EventSource)this.delegate().createEntityManager(synchronizationType, map));
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        throw new IllegalStateException("Hibernate OGM does not support entity graphs");
    }

    public EntityGraph findEntityGraphByName(String name) {
        throw new IllegalStateException("Hibernate OGM does not support entity graphs");
    }

    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        throw new IllegalStateException("Hibernate OGM does not support entity graphs");
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(SessionFactory.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(SessionFactoryImplementor.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(SessionFactoryImpl.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(OgmSessionFactory.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(OgmSessionFactoryImplementor.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(OgmSessionFactoryImpl.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(EntityManagerFactory.class)) {
            return type.cast(this);
        }
        throw new PersistenceException("Hibernate cannot unwrap EntityManagerFactory as '" + type.getName() + "'");
    }
}

