/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.jpa;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.hibernate.ogm.jpa.impl.DelegatorPersistenceUnitInfo;

public class HibernateOgmPersistence
implements PersistenceProvider {
    private static String IMPLEMENTATION_NAME = HibernateOgmPersistence.class.getName();
    private final HibernatePersistenceProvider delegate = new HibernatePersistenceProvider();

    public EntityManagerFactory createEntityManagerFactory(String emName, Map map) {
        try {
            Map integration = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
            List metadataFiles = PersistenceXmlParser.locatePersistenceUnits(integration);
            for (ParsedPersistenceXmlDescriptor metadata : metadataFiles) {
                if (!IMPLEMENTATION_NAME.equalsIgnoreCase(metadata.getProviderClassName())) continue;
                HashMap<Object, Object> protectiveCopy = new HashMap<Object, Object>(integration);
                this.enforceOgmConfig(protectiveCopy);
                protectiveCopy.put("javax.persistence.provider", this.delegate.getClass().getName());
                return this.delegate.createEntityManagerFactory(emName, protectiveCopy);
            }
            return null;
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PersistenceException("Unable to build EntityManagerFactory", (Throwable)e);
        }
    }

    private void enforceOgmConfig(Map<Object, Object> map) {
        map.put("hibernate.connection.datasource", "---PlaceHolderDSForOGM---");
        map.put("hibernate.ogm.enabled", true);
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        String persistenceProviderClassName = info.getPersistenceProviderClassName();
        if (persistenceProviderClassName == null || IMPLEMENTATION_NAME.equals(persistenceProviderClassName)) {
            HashMap<Object, Object> protectiveCopy = map != null ? new HashMap<Object, Object>(map) : new HashMap();
            this.enforceOgmConfig(protectiveCopy);
            return this.delegate.createContainerEntityManagerFactory((PersistenceUnitInfo)new DelegatorPersistenceUnitInfo(info), protectiveCopy);
        }
        return null;
    }

    public ProviderUtil getProviderUtil() {
        return this.delegate.getProviderUtil();
    }

    public void generateSchema(PersistenceUnitInfo info, Map map) {
        throw new IllegalStateException("Hibernate OGM does not support schema generation");
    }

    public boolean generateSchema(String persistenceUnitName, Map map) {
        throw new IllegalStateException("Hibernate OGM does not support schema generation");
    }
}

