/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.loader.entity.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.ogm.loader.entity.impl.BatchableEntityLoader;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public abstract class BatchingEntityLoader
implements UniqueEntityLoader {
    private static final Logger log = Logger.getLogger(BatchingEntityLoader.class);
    private final EntityPersister persister;

    public BatchingEntityLoader(EntityPersister persister) {
        this.persister = persister;
    }

    public EntityPersister persister() {
        return this.persister;
    }

    @Deprecated
    public Object load(Serializable id, Object optionalObject, SharedSessionContractImplementor session) {
        return this.load(id, optionalObject, session, LockOptions.NONE);
    }

    protected QueryParameters buildQueryParameters(Serializable id, Serializable[] ids, Object optionalObject, LockOptions lockOptions) {
        Object[] types = new Type[ids.length];
        Arrays.fill(types, this.persister().getIdentifierType());
        QueryParameters qp = new QueryParameters();
        qp.setPositionalParameterTypes((Type[])types);
        qp.setPositionalParameterValues((Object[])ids);
        qp.setOptionalObject(optionalObject);
        qp.setOptionalEntityName(this.persister().getEntityName());
        qp.setOptionalId(id);
        qp.setLockOptions(lockOptions);
        return qp;
    }

    protected Object getObjectFromList(List results, Serializable id, SharedSessionContractImplementor session) {
        for (Object obj : results) {
            boolean equal = this.persister.getIdentifierType().isEqual((Object)id, (Object)session.getContextEntityIdentifier(obj), session.getFactory());
            if (!equal) continue;
            return obj;
        }
        return null;
    }

    protected Object doBatchLoad(Serializable id, BatchableEntityLoader loaderToUse, SharedSessionContractImplementor session, Serializable[] ids, Object optionalObject, LockOptions lockOptions) {
        List<?> results = loaderToUse.loadEntityBatch(session, ids, this.persister.getIdentifierType(), optionalObject, this.persister.getEntityName(), id, this.persister, lockOptions);
        return this.getObjectFromList(results, id, session);
    }
}

