/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.loader.nativeloader.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.Return;
import org.hibernate.loader.custom.RootReturn;
import org.hibernate.loader.custom.sql.SQLQueryReturnProcessor;
import org.hibernate.ogm.model.spi.EntityMetadataInformation;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.param.ParameterBinder;

public class BackendCustomQuery<T extends Serializable>
implements CustomQuery,
Serializable {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final String queryString;
    private final T queryObject;
    private final Set<String> querySpaces;
    private final List<Return> customQueryReturns;
    private final EntityMetadataInformation singleEntityMetadataInformation;

    public BackendCustomQuery(String queryString, T query, NativeSQLQueryReturn[] queryReturns, Set<String> querySpaces, SessionFactoryImplementor factory) throws HibernateException {
        LOG.tracev("Starting processing of NoSQL query [{0}]", queryString);
        this.queryString = queryString;
        this.queryObject = query;
        SQLQueryReturnProcessor processor = new SQLQueryReturnProcessor(queryReturns, factory);
        processor.process();
        this.customQueryReturns = Collections.unmodifiableList(processor.generateCustomReturns(false));
        this.querySpaces = querySpaces != null ? Collections.unmodifiableSet(querySpaces) : Collections.emptySet();
        this.singleEntityMetadataInformation = this.determineSingleEntityMetadataInformation(factory, this.customQueryReturns);
    }

    private EntityMetadataInformation determineSingleEntityMetadataInformation(SessionFactoryImplementor sessionFactory, List<Return> customQueryReturns) {
        EntityMetadataInformation metadataInformation = null;
        for (Return queryReturn : customQueryReturns) {
            if (!(queryReturn instanceof RootReturn)) continue;
            if (metadataInformation != null) {
                return null;
            }
            RootReturn rootReturn = (RootReturn)queryReturn;
            OgmEntityPersister persister = (OgmEntityPersister)sessionFactory.getMetamodel().entityPersister(rootReturn.getEntityName());
            metadataInformation = new EntityMetadataInformation(persister.getEntityKeyMetadata(), rootReturn.getEntityName());
        }
        return metadataInformation;
    }

    @Deprecated
    public String getSQL() {
        return this.getQueryString();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public T getQueryObject() {
        return this.queryObject;
    }

    public Set<String> getQuerySpaces() {
        return this.querySpaces;
    }

    public List<ParameterBinder> getParameterValueBinders() {
        return Collections.emptyList();
    }

    public List<Return> getCustomQueryReturns() {
        return this.customQueryReturns;
    }

    public EntityMetadataInformation getSingleEntityMetadataInformationOrNull() {
        return this.singleEntityMetadataInformation;
    }

    public String toString() {
        return this.queryObject != null ? this.queryObject.toString() : this.queryString;
    }
}

