/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.massindex.impl;

import java.lang.invoke.MethodHandles;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TuplesSupplier;
import org.hibernate.ogm.massindex.impl.SessionAwareRunnable;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.TransactionContextHelper;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;

public class OptionallyWrapInJTATransaction
implements ModelConsumer {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final SessionFactoryImplementor factory;
    private final SessionAwareRunnable delegate;
    private final ErrorHandler errorHandler;

    public OptionallyWrapInJTATransaction(SessionFactory factory, ErrorHandler errorHandler, SessionAwareRunnable sessionAwareRunnable) {
        this.factory = (SessionFactoryImplementor)factory;
        this.delegate = sessionAwareRunnable;
        this.errorHandler = errorHandler;
    }

    private TransactionManager getTransactionManager() {
        return ((JtaPlatform)this.factory.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
    }

    boolean wrapInTransaction() {
        TransactionCoordinatorBuilder transactionCoordinatorBuilder = (TransactionCoordinatorBuilder)this.factory.getServiceRegistry().getService(TransactionCoordinatorBuilder.class);
        if (!transactionCoordinatorBuilder.isJta()) {
            log.trace((Object)"TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction");
            return false;
        }
        TransactionManager transactionManager = this.getTransactionManager();
        if (transactionManager == null) {
            log.trace((Object)"No TransactionManager found, do not start a surrounding JTA transaction");
            return false;
        }
        try {
            if (transactionManager.getStatus() == 6) {
                log.trace((Object)"No Transaction in progress, needs to start a JTA transaction");
                return true;
            }
        }
        catch (SystemException e) {
            log.cannotGuessTransactionStatus((Exception)((Object)e));
            return false;
        }
        log.trace((Object)"Transaction in progress, no needs to start a JTA transaction");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(TuplesSupplier supplier) {
        block7: {
            try {
                boolean wrapInTransaction = this.wrapInTransaction();
                if (wrapInTransaction) {
                    this.consumeInTransaction(supplier);
                    break block7;
                }
                try (ClosableIterator<Tuple> tuples = supplier.get(null);){
                    while (tuples.hasNext()) {
                        Tuple tuple = (Tuple)tuples.next();
                        this.delegate.run(null, tuple);
                    }
                }
            }
            catch (Throwable e) {
                this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeInTransaction(TuplesSupplier supplier) {
        TransactionManager transactionManager = this.getTransactionManager();
        try {
            transactionManager.begin();
            try (Session session = this.factory.openSession();){
                TransactionContext transactionContext = TransactionContextHelper.transactionContext(session);
                try (ClosableIterator<Tuple> tuples = supplier.get(transactionContext);){
                    while (tuples.hasNext()) {
                        Tuple tuple = (Tuple)tuples.next();
                        this.delegate.run(session, tuple);
                    }
                    transactionManager.commit();
                }
            }
        }
        catch (Throwable e) {
            this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
            this.rollback(transactionManager, e);
        }
    }

    private void rollback(TransactionManager transactionManager, Throwable e) {
        try {
            transactionManager.rollback();
        }
        catch (SystemException e1) {
            log.errorRollingBackTransaction(e.getMessage(), (Exception)((Object)e1));
        }
    }
}

