/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Tuple;

public class RowKeyBuilder {
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> indexColumnNames = new ArrayList<String>(3);
    private Tuple tuple;

    public RowKeyBuilder addColumns(String ... columns) {
        for (String columnName : columns) {
            this.columnNames.add(columnName);
        }
        return this;
    }

    public RowKeyBuilder addIndexColumns(String ... columns) {
        for (String columnName : columns) {
            this.columnNames.add(columnName);
            this.indexColumnNames.add(columnName);
        }
        return this;
    }

    public RowKey build() {
        String[] columnNamesArray = this.columnNames.toArray(new String[this.columnNames.size()]);
        int length = columnNamesArray.length;
        Object[] columnValuesArray = new Object[length];
        for (int index = 0; index < length; ++index) {
            columnValuesArray[index] = this.tuple.get(columnNamesArray[index]);
        }
        return new RowKey(columnNamesArray, columnValuesArray);
    }

    public RowKeyBuilder values(Tuple tuple) {
        this.tuple = tuple;
        return this;
    }

    public String[] getColumnNames() {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    public String[] getIndexColumnNames() {
        return this.indexColumnNames.toArray(new String[this.indexColumnNames.size()]);
    }
}

