/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.key.spi;

import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;

public final class IdSourceKey {
    private final IdSourceKeyMetadata metadata;
    private final String columnName;
    private final String columnValue;
    private final int hashCode;

    private IdSourceKey(IdSourceKeyMetadata metadata, String columnValue) {
        this.metadata = metadata;
        this.columnName = metadata.getKeyColumnName();
        this.columnValue = columnValue;
        this.hashCode = this.calculateHashCode();
    }

    public static IdSourceKey forTable(IdSourceKeyMetadata metadata, String segmentName) {
        return new IdSourceKey(metadata, segmentName);
    }

    public static IdSourceKey forSequence(IdSourceKeyMetadata metadata) {
        return new IdSourceKey(metadata, null);
    }

    public IdSourceKeyMetadata getMetadata() {
        return this.metadata;
    }

    public String getTable() {
        return this.metadata.getName();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnValue() {
        return this.columnValue;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (IdSourceKey.class != obj.getClass()) {
            return false;
        }
        IdSourceKey other = (IdSourceKey)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        if (this.columnValue == null ? other.columnValue != null : !this.columnValue.equals(other.columnValue)) {
            return false;
        }
        if (this.hashCode != other.hashCode) {
            return false;
        }
        return !(this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata));
    }

    public String toString() {
        return "IdSourceKey [metadata=" + this.metadata + ", columnName='" + this.columnName + "', columnValue='" + this.columnValue + "']";
    }

    private int calculateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.columnValue == null ? 0 : this.columnValue.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        return result;
    }
}

