/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.persister.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.ogm.persister.impl.EntityDiscriminator;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

class ColumnBasedDiscriminator
implements EntityDiscriminator {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final Object NULL_DISCRIMINATOR = new MarkerObject("<null discriminator>");
    private static final Object NOT_NULL_DISCRIMINATOR = new MarkerObject("<not null discriminator>");
    private final String alias;
    private final String columnName;
    private final Type discriminatorType;
    private final boolean forced;
    private final boolean needed;
    private final String sqlValue;
    private final Object value;
    private final Map<Object, String> subclassesByValue;

    public ColumnBasedDiscriminator(PersistentClass persistentClass, SessionFactoryImplementor factory, Column column) {
        Dialect dialect = ((JdbcServices)factory.getServiceRegistry().getService(JdbcServices.class)).getDialect();
        this.forced = persistentClass.isForceDiscriminator();
        this.columnName = column.getQuotedName(dialect);
        this.alias = column.getAlias(dialect, persistentClass.getRootTable());
        this.discriminatorType = persistentClass.getDiscriminator().getType() == null ? StringType.INSTANCE : persistentClass.getDiscriminator().getType();
        this.value = ColumnBasedDiscriminator.value(persistentClass, this.discriminatorType);
        this.sqlValue = ColumnBasedDiscriminator.sqlValue(persistentClass, dialect, this.value, this.discriminatorType);
        this.subclassesByValue = ColumnBasedDiscriminator.subclassesByValue(persistentClass, this.value, this.discriminatorType);
        this.needed = true;
    }

    private static Map<Object, String> subclassesByValue(PersistentClass persistentClass, Object value, Type type) {
        HashMap<Object, String> subclassesByDsicriminator = new HashMap<Object, String>();
        subclassesByDsicriminator.put(value, persistentClass.getEntityName());
        if (persistentClass.isPolymorphic()) {
            Iterator iter = persistentClass.getSubclassIterator();
            while (iter.hasNext()) {
                Subclass sc = (Subclass)iter.next();
                subclassesByDsicriminator.put(ColumnBasedDiscriminator.value((PersistentClass)sc, type), sc.getEntityName());
            }
        }
        return subclassesByDsicriminator;
    }

    public static String sqlValue(PersistentClass persistentClass, Dialect dialect, Object value, Type discriminatorType) {
        try {
            return ColumnBasedDiscriminator.obtainSqlValue(persistentClass, dialect, value, discriminatorType);
        }
        catch (ClassCastException cce) {
            throw log.illegalDiscrimantorType(discriminatorType.getName());
        }
        catch (Exception e) {
            throw log.unableToConvertStringToDiscriminator(e);
        }
    }

    private static String obtainSqlValue(PersistentClass persistentClass, Dialect dialect, Object value, Type discriminatorType) throws Exception {
        if (persistentClass.isDiscriminatorValueNull()) {
            return "null";
        }
        if (persistentClass.isDiscriminatorValueNotNull()) {
            return "not null";
        }
        DiscriminatorType dtype = (DiscriminatorType)discriminatorType;
        return dtype.objectToSQLString(value, dialect);
    }

    public static Object value(PersistentClass persistentClass, Type discriminatorType) {
        try {
            return ColumnBasedDiscriminator.obtainValue(persistentClass, discriminatorType);
        }
        catch (ClassCastException cce) {
            throw log.illegalDiscrimantorType(discriminatorType.getName());
        }
        catch (Exception e) {
            throw log.unableToConvertStringToDiscriminator(e);
        }
    }

    private static Object obtainValue(PersistentClass persistentClass, Type discriminatorType) throws Exception {
        if (persistentClass.isDiscriminatorValueNull()) {
            return NULL_DISCRIMINATOR;
        }
        if (persistentClass.isDiscriminatorValueNotNull()) {
            return NOT_NULL_DISCRIMINATOR;
        }
        DiscriminatorType dtype = (DiscriminatorType)discriminatorType;
        return dtype.stringToObject(persistentClass.getDiscriminatorValue());
    }

    @Override
    public String provideClassByValue(Object value) {
        return this.subclassesByValue.get(value);
    }

    @Override
    public String getSqlValue() {
        return this.sqlValue;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public Type getType() {
        return this.discriminatorType;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isForced() {
        return this.forced;
    }

    @Override
    public boolean isNeeded() {
        return this.needed;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ColumnBasedDiscriminator [alias=");
        builder.append(this.alias);
        builder.append(", columnName=");
        builder.append(this.columnName);
        builder.append(", discriminatorType=");
        builder.append(this.discriminatorType);
        builder.append(", forced=");
        builder.append(this.forced);
        builder.append(", needed=");
        builder.append(this.needed);
        builder.append(", sqlValue=");
        builder.append(this.sqlValue);
        builder.append(", value=");
        builder.append(this.value);
        builder.append(", subclassByValue=");
        builder.append(this.subclassesByValue);
        builder.append("]");
        return builder.toString();
    }
}

