/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.persister.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.ogm.dialect.impl.AssociationTypeContextImpl;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.model.impl.RowKeyBuilder;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.persister.impl.BiDirectionalAssociationHelper;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.util.impl.AssociationPersister;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.LogicalPhysicalConverterHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;

class EntityAssociationUpdater {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final OgmEntityPersister persister;
    private final GridDialect gridDialect;
    private Tuple resultset;
    private int tableIndex;
    private Serializable id;
    private SharedSessionContractImplementor session;
    private boolean[] propertyMightRequireInverseAssociationManagement;

    EntityAssociationUpdater(OgmEntityPersister persister) {
        this.persister = persister;
        this.gridDialect = (GridDialect)persister.getFactory().getServiceRegistry().getService(GridDialect.class);
    }

    public EntityAssociationUpdater resultset(Tuple resultset) {
        this.resultset = resultset;
        return this;
    }

    public EntityAssociationUpdater tableIndex(int tableIndex) {
        this.tableIndex = tableIndex;
        return this;
    }

    public EntityAssociationUpdater id(Serializable id) {
        this.id = id;
        return this;
    }

    public EntityAssociationUpdater session(SharedSessionContractImplementor session) {
        this.session = session;
        return this;
    }

    public EntityAssociationUpdater propertyMightRequireInverseAssociationManagement(boolean[] propertyInverseAssociationManagementMayBeRequired) {
        this.propertyMightRequireInverseAssociationManagement = propertyInverseAssociationManagementMayBeRequired;
        return this;
    }

    public void addNavigationalInformationForInverseSide() {
        if (log.isTraceEnabled()) {
            log.trace("Adding inverse navigational information for entity: " + MessageHelper.infoString((EntityPersister)this.persister, (Object)this.id, (SessionFactoryImplementor)this.persister.getFactory()));
        }
        for (int propertyIndex = 0; propertyIndex < this.persister.getEntityMetamodel().getPropertySpan(); ++propertyIndex) {
            Object[] newColumnValues;
            AssociationKeyMetadata associationKeyMetadata;
            if (!this.persister.isPropertyOfTable(propertyIndex, this.tableIndex) || (associationKeyMetadata = this.getInverseAssociationKeyMetadata(propertyIndex)) == null || CollectionHelper.isEmptyOrContainsOnlyNull(newColumnValues = LogicalPhysicalConverterHelper.getColumnValuesFromResultset(this.resultset, this.persister.getPropertyColumnNames(propertyIndex)))) continue;
            this.addNavigationalInformationForInverseSide(propertyIndex, associationKeyMetadata, newColumnValues);
        }
    }

    public void removeNavigationalInformationFromInverseSide() {
        if (log.isTraceEnabled()) {
            log.trace("Removing inverse navigational information for entity: " + MessageHelper.infoString((EntityPersister)this.persister, (Object)this.id, (SessionFactoryImplementor)this.persister.getFactory()));
        }
        for (int propertyIndex = 0; propertyIndex < this.persister.getEntityMetamodel().getPropertySpan(); ++propertyIndex) {
            Object[] oldColumnValues;
            AssociationKeyMetadata associationKeyMetadata;
            if (!this.persister.isPropertyOfTable(propertyIndex, this.tableIndex) || (associationKeyMetadata = this.getInverseAssociationKeyMetadata(propertyIndex)) == null || CollectionHelper.isEmptyOrContainsOnlyNull(oldColumnValues = LogicalPhysicalConverterHelper.getColumnValuesFromResultset(this.resultset, this.persister.getPropertyColumnNames(propertyIndex)))) continue;
            this.removeNavigationalInformationFromInverseSide(propertyIndex, associationKeyMetadata, oldColumnValues);
        }
    }

    private void addNavigationalInformationForInverseSide(int propertyIndex, AssociationKeyMetadata associationKeyMetadata, Object[] newColumnValue) {
        RowKey rowKey = this.getInverseRowKey(associationKeyMetadata, newColumnValue);
        Tuple associationRow = new Tuple();
        for (String column : rowKey.getColumnNames()) {
            associationRow.put(column, rowKey.getColumnValue(column));
        }
        AssociationPersister associationPersister = this.createInverseAssociationPersister(propertyIndex, associationKeyMetadata, newColumnValue);
        associationPersister.getAssociation().put(rowKey, associationRow);
        if (associationPersister.getAssociationContext().getEntityTuplePointer().getTuple() == null) {
            throw log.entityTupleNotFound(associationKeyMetadata.getCollectionRole(), associationPersister.getAssociationKey().getEntityKey());
        }
        associationPersister.flushToDatastore();
    }

    private void removeNavigationalInformationFromInverseSide(int propertyIndex, AssociationKeyMetadata associationKeyMetadata, Object[] oldColumnValue) {
        AssociationPersister associationPersister = this.createInverseAssociationPersister(propertyIndex, associationKeyMetadata, oldColumnValue);
        Association association = associationPersister.getAssociationOrNull();
        if (association != null && !association.isEmpty()) {
            RowKey rowKey = this.getInverseRowKey(associationKeyMetadata, oldColumnValue);
            association.remove(rowKey);
            associationPersister.flushToDatastore();
        }
    }

    private AssociationPersister createInverseAssociationPersister(int propertyIndex, AssociationKeyMetadata associationKeyMetadata, Object[] keyColumnValues) {
        OptionsService.OptionsServiceContext serviceContext = ((OptionsService)this.session.getFactory().getServiceRegistry().getService(OptionsService.class)).context();
        Class entityType = this.persister.getPropertyTypes()[propertyIndex].getReturnedClass();
        OgmEntityPersister inverseEntityPersister = (OgmEntityPersister)this.persister.getFactory().getMetamodel().entityPersister(entityType);
        String mainSidePropertyName = this.persister.getPropertyNames()[propertyIndex];
        AssociationTypeContextImpl associationTypeContext = new AssociationTypeContextImpl.Builder(serviceContext).associationKeyMetadata(associationKeyMetadata).hostingEntityPersister(inverseEntityPersister).mainSidePropertyName(mainSidePropertyName).build();
        return new AssociationPersister.Builder(this.persister.getPropertyTypes()[propertyIndex].getReturnedClass()).hostingEntity(this.getReferencedEntity(propertyIndex)).gridDialect(this.gridDialect).associationKeyMetadata(associationKeyMetadata).keyColumnValues(keyColumnValues).session(this.session).associationTypeContext(associationTypeContext).build();
    }

    private Object getReferencedEntity(int propertyIndex) {
        EntityPersister hostingEntityPersister;
        Class entityType;
        Object referencedEntity = null;
        GridType propertyType = this.persister.getGridPropertyTypes()[propertyIndex];
        Serializable id = (Serializable)propertyType.hydrate(this.resultset, this.persister.getPropertyColumnNames(propertyIndex), this.session, null);
        if (id != null && (referencedEntity = ((Session)this.session).get(entityType = (hostingEntityPersister = this.session.getFactory().getMetamodel().entityPersister(propertyType.getReturnedClass())).getMappedClass(), id)) == null) {
            referencedEntity = this.session.getPersistenceContext().getEntity(this.session.generateEntityKey(id, hostingEntityPersister));
        }
        return referencedEntity;
    }

    private RowKey getInverseRowKey(AssociationKeyMetadata associationKeyMetadata, Object[] associationColumnValues) {
        Tuple rowKeyValues = new Tuple();
        for (int index = 0; index < associationKeyMetadata.getColumnNames().length; ++index) {
            rowKeyValues.put(associationKeyMetadata.getColumnNames()[index], associationColumnValues[index]);
        }
        this.persister.getGridIdentifierType().nullSafeSet(rowKeyValues, this.id, this.persister.getIdentifierColumnNames(), this.session);
        return new RowKeyBuilder().addColumns(associationKeyMetadata.getRowKeyColumnNames()).values(rowKeyValues).build();
    }

    private AssociationKeyMetadata getInverseAssociationKeyMetadata(int propertyIndex) {
        if (!this.propertyMightRequireInverseAssociationManagement[propertyIndex]) {
            return null;
        }
        return BiDirectionalAssociationHelper.getInverseAssociationKeyMetadata(this.persister, propertyIndex);
    }
}

