/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.query.parsing.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.hql.ast.origin.hql.resolve.path.AggregationPropertyPath;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;

public abstract class KeepNamedParametersQueryRendererDelegate<Q, R>
extends SingleEntityQueryRendererDelegate<Q, R> {
    protected PropertyHelper propertyHelper;

    public KeepNamedParametersQueryRendererDelegate(PropertyHelper propertyHelper, EntityNamesResolver entityNames, SingleEntityQueryBuilder<Q> builder, Map<String, Object> namedParameters) {
        super(propertyHelper, entityNames, builder, namedParameters);
        this.propertyHelper = propertyHelper;
    }

    public void predicateLike(String patternValue, Character escapeCharacter) {
        Object pattern = this.parameterValue(patternValue);
        List property = this.resolveAlias(this.propertyPath);
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_WHERE) {
            this.builder.addLikePredicate(property, (String)pattern, escapeCharacter);
        } else if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_HAVING) {
            this.getHavingBuilder().addLikePredicate(this.getAggregation(), property, (String)pattern, escapeCharacter);
        } else {
            throw new IllegalStateException();
        }
    }

    public void predicateBetween(String lower, String upper) {
        Object lowerComparisonValue = this.parameterValue(lower);
        Object upperComparisonValue = this.parameterValue(upper);
        List property = this.resolveAlias(this.propertyPath);
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_WHERE) {
            this.builder.addRangePredicate(property, lowerComparisonValue, upperComparisonValue);
        } else if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_HAVING) {
            this.getHavingBuilder().addRangePredicate(this.getAggregation(), property, lowerComparisonValue, upperComparisonValue);
        } else {
            throw new IllegalStateException();
        }
    }

    public void predicateLess(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS);
    }

    public void predicateLessOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS_OR_EQUAL);
    }

    public void predicateEquals(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
    }

    public void predicateNotEquals(String comparativePredicate) {
        this.activateNOT();
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
        this.deactivateBoolean();
    }

    public void predicateGreaterOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER_OR_EQUAL);
    }

    public void predicateGreater(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER);
    }

    public void predicateIn(List<String> list) {
        List<Object> values = this.fromNamedQuery(list);
        List property = this.resolveAlias(this.propertyPath);
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_WHERE) {
            this.builder.addInPredicate(property, values);
        } else if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_HAVING) {
            this.getHavingBuilder().addInPredicate(this.getAggregation(), property, values);
        } else {
            throw new IllegalStateException();
        }
    }

    private AggregationPropertyPath.Type getAggregation() {
        if (this.propertyPath instanceof AggregationPropertyPath) {
            return ((AggregationPropertyPath)this.propertyPath).getType();
        }
        return null;
    }

    private void addComparisonPredicate(String comparativePredicate, ComparisonPredicate.Type comparisonType) {
        Object comparisonValue = this.parameterValue(comparativePredicate);
        List property = this.resolveAlias(this.propertyPath);
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_WHERE) {
            this.builder.addComparisonPredicate(property, comparisonType, comparisonValue);
        } else if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_HAVING) {
            this.getHavingBuilder().addComparisonPredicate(this.getAggregation(), property, comparisonType, comparisonValue);
        } else {
            throw new IllegalStateException();
        }
    }

    protected List<Object> fromNamedQuery(List<String> list) {
        ArrayList<Object> elements = new ArrayList<Object>(list.size());
        for (String string : list) {
            elements.add(this.parameterValue(string));
        }
        return elements;
    }

    protected Object parameterValue(String comparativePredicate) {
        if (comparativePredicate.startsWith(":")) {
            return this.getObjectParameter(comparativePredicate);
        }
        ArrayList path = new ArrayList();
        path.addAll(this.propertyPath.getNodeNamesWithoutAlias());
        PropertyPath fullPath = this.propertyPath;
        while (fullPath.getFirstNode().isAlias() && this.aliasToPropertyPath.containsKey(fullPath.getFirstNode().getName())) {
            fullPath = (PropertyPath)this.aliasToPropertyPath.get(fullPath.getFirstNode().getName());
            path.addAll(0, fullPath.getNodeNamesWithoutAlias());
        }
        return this.propertyHelper.convertToPropertyType(this.targetTypeName, path, comparativePredicate);
    }

    protected Object getObjectParameter(String comparativePredicate) {
        return comparativePredicate;
    }
}

