/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.ogm.cfg.impl.Version;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManager;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManagingAutoFlushEventListener;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManagingFlushEventListener;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManagingPersistEventListener;
import org.hibernate.ogm.dialect.impl.SessionFactoryLifecycleAwareDialectInitializer;
import org.hibernate.ogm.service.impl.OgmConfigurationService;
import org.hibernate.ogm.service.impl.SchemaDefiningObserver;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class OgmIntegrator
implements Integrator {
    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.doIntegrate(metadata, sessionFactory, serviceRegistry);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private void doIntegrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (!((OgmConfigurationService)serviceRegistry.getService(OgmConfigurationService.class)).isOgmEnabled()) {
            return;
        }
        Version.touch();
        sessionFactory.addObserver((SessionFactoryObserver)new SchemaDefiningObserver(metadata));
        sessionFactory.addObserver((SessionFactoryObserver)new SessionFactoryLifecycleAwareDialectInitializer());
        this.attachEventContextManagingListenersIfRequired(serviceRegistry);
    }

    private void attachEventContextManagingListenersIfRequired(SessionFactoryServiceRegistry serviceRegistry) {
        if (!EventContextManager.isEventContextRequired((ServiceRegistryImplementor)serviceRegistry)) {
            return;
        }
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        EventContextManager stateManager = (EventContextManager)serviceRegistry.getService(EventContextManager.class);
        eventListenerRegistry.addDuplicationStrategy(EventContextManagingAutoFlushEventListener.EventContextManagingAutoFlushEventListenerDuplicationStrategy.INSTANCE);
        eventListenerRegistry.getEventListenerGroup(EventType.AUTO_FLUSH).appendListener((Object)new EventContextManagingAutoFlushEventListener(stateManager));
        eventListenerRegistry.addDuplicationStrategy(EventContextManagingFlushEventListener.EventContextManagingFlushEventListenerDuplicationStrategy.INSTANCE);
        eventListenerRegistry.getEventListenerGroup(EventType.FLUSH).appendListener((Object)new EventContextManagingFlushEventListener(stateManager));
        eventListenerRegistry.addDuplicationStrategy(EventContextManagingPersistEventListener.EventContextManagingPersistEventListenerDuplicationStrategy.INSTANCE);
        eventListenerRegistry.getEventListenerGroup(EventType.PERSIST).appendListener((Object)new EventContextManagingPersistEventListener(stateManager));
    }
}

