/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.service.impl.OgmSessionFactoryServiceInitiators;
import org.hibernate.service.internal.SessionFactoryServiceRegistryBuilderImpl;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceContributor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistryBuilder;
import org.hibernate.service.spi.SessionFactoryServiceRegistryFactory;

public class OgmSessionFactoryServiceRegistryFactoryImpl
implements SessionFactoryServiceRegistryFactory {
    private final ServiceRegistryImplementor theBasicServiceRegistry;

    public OgmSessionFactoryServiceRegistryFactoryImpl(ServiceRegistryImplementor theBasicServiceRegistry) {
        this.theBasicServiceRegistry = theBasicServiceRegistry;
    }

    public SessionFactoryServiceRegistry buildServiceRegistry(SessionFactoryImplementor sessionFactory, BootstrapContext bootstrapContext, SessionFactoryOptions options) {
        ClassLoaderService cls = (ClassLoaderService)options.getServiceRegistry().getService(ClassLoaderService.class);
        SessionFactoryServiceRegistryBuilderImpl builder = new SessionFactoryServiceRegistryBuilderImpl(this.theBasicServiceRegistry);
        for (SessionFactoryServiceInitiator<?> initiator : OgmSessionFactoryServiceInitiators.LIST) {
            builder.addInitiator(initiator);
        }
        for (SessionFactoryServiceContributor contributor : cls.loadJavaServices(SessionFactoryServiceContributor.class)) {
            contributor.contribute((SessionFactoryServiceRegistryBuilder)builder);
        }
        return builder.buildSessionFactoryServiceRegistry(sessionFactory, bootstrapContext, options);
    }
}

