/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.storedprocedure.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.ParameterMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.storedprocedure.spi.StoredProcedureAwareGridDialect;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.EntityMetadataInformation;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.storedprocedure.ProcedureQueryParameters;
import org.hibernate.ogm.storedprocedure.impl.NoSQLProcedureResultSetOutputImpl;
import org.hibernate.ogm.util.impl.CustomLoaderHelper;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.TupleContextHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.ParameterRegistration;
import org.hibernate.procedure.ProcedureOutputs;
import org.hibernate.procedure.internal.NoSQLProcedureCallImpl;
import org.hibernate.result.Output;

public class NoSQLProcedureOutputsImpl
implements ProcedureOutputs {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final NoSQLProcedureCallImpl procedureCall;
    private final SessionFactoryImplementor sessionFactory;
    private StoredProcedureAwareGridDialect gridDialect;

    public NoSQLProcedureOutputsImpl(NoSQLProcedureCallImpl procedureCall) {
        this.procedureCall = procedureCall;
        this.sessionFactory = procedureCall.getSession().getFactory();
        this.gridDialect = (StoredProcedureAwareGridDialect)this.sessionFactory.getServiceRegistry().getService(StoredProcedureAwareGridDialect.class);
    }

    public <T> T getOutputParameterValue(ParameterRegistration<T> parameterRegistration) {
        throw new UnsupportedOperationException("Out parameters not supported yet!");
    }

    public Object getOutputParameterValue(String name) {
        throw new UnsupportedOperationException("Out parameters not supported yet!");
    }

    public Object getOutputParameterValue(int position) {
        throw new UnsupportedOperationException("Out parameters not supported yet!");
    }

    public Output getCurrent() {
        ProcedureQueryParameters queryParameters = this.createProcedureQueryParameters(this.procedureCall.getRegisteredParameters());
        if (!this.procedureCall.getSynchronizedQuerySpaces().isEmpty()) {
            return this.entitiesOutput(this.procedureCall, queryParameters);
        }
        TupleContext tupleContext = TupleContextHelper.tupleContext(this.procedureCall.getSession(), null);
        ClosableIterator<Tuple> result = this.gridDialect.callStoredProcedure(this.procedureCall.getProcedureName(), queryParameters, tupleContext);
        if (result == null) {
            return null;
        }
        return NoSQLProcedureOutputsImpl.objectsOuput(result);
    }

    private Output entitiesOutput(NoSQLProcedureCallImpl procedureCall, ProcedureQueryParameters queryParameters) {
        if (procedureCall.getSynchronizedQuerySpaces().size() > 1) {
            throw log.multipleEntitiesOutputNotSupported(procedureCall.getProcedureName(), procedureCall.getSynchronizedQuerySpaces());
        }
        Iterator iterator = procedureCall.getSynchronizedQuerySpaces().iterator();
        String querySpace = (String)iterator.next();
        MetamodelImplementor metamodelImplementor = procedureCall.getSession().getFactory().getMetamodel();
        OgmEntityPersister entityPersister = this.entityPersister(querySpace, metamodelImplementor);
        EntityMetadataInformation entityMetadata = this.entityMetadataInfo(querySpace, metamodelImplementor, entityPersister);
        TupleContext tupleContext = TupleContextHelper.tupleContext(procedureCall.getSession(), entityMetadata);
        ClosableIterator<Tuple> result = this.gridDialect.callStoredProcedure(procedureCall.getProcedureName(), queryParameters, tupleContext);
        List<Object> entityList = CustomLoaderHelper.listOfEntities(procedureCall.getSession(), entityPersister.getMappedClass(), result);
        return new NoSQLProcedureResultSetOutputImpl(entityList);
    }

    private EntityMetadataInformation entityMetadataInfo(String querySpace, MetamodelImplementor metamodelImplementor, OgmEntityPersister entityPersister) {
        String entityName = null;
        for (Map.Entry entry : metamodelImplementor.entityPersisters().entrySet()) {
            List<Serializable> querySpaces = Arrays.asList(((EntityPersister)entry.getValue()).getQuerySpaces());
            if (!querySpaces.contains(querySpace)) continue;
            entityName = (String)entry.getKey();
        }
        EntityKeyMetadata entityKeyMetadata = entityPersister.getEntityKeyMetadata();
        EntityMetadataInformation entityMetadata = new EntityMetadataInformation(entityKeyMetadata, entityName);
        return entityMetadata;
    }

    private OgmEntityPersister entityPersister(String querySpace, MetamodelImplementor metamodelImplementor) {
        for (Map.Entry entry : metamodelImplementor.entityPersisters().entrySet()) {
            List<Serializable> querySpaces = Arrays.asList(((EntityPersister)entry.getValue()).getQuerySpaces());
            if (!querySpaces.contains(querySpace)) continue;
            return (OgmEntityPersister)((Object)entry.getValue());
        }
        return null;
    }

    private ProcedureQueryParameters createProcedureQueryParameters(List<ParameterRegistration<?>> list) {
        ArrayList<Object> positionalParameters = new ArrayList<Object>();
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        for (ParameterRegistration<?> nosqlParameterRegistration : list) {
            if (nosqlParameterRegistration.getMode() == ParameterMode.REF_CURSOR) continue;
            Object value = nosqlParameterRegistration.getBind().getValue();
            if (nosqlParameterRegistration.getName() != null) {
                namedParameters.put(nosqlParameterRegistration.getName(), value);
                continue;
            }
            if (nosqlParameterRegistration.getPosition() == null) continue;
            positionalParameters.add(value);
        }
        return new ProcedureQueryParameters(namedParameters, positionalParameters);
    }

    private static Output objectsOuput(ClosableIterator<Tuple> tuples) {
        ArrayList<Object> tuplesAsList = new ArrayList<Object>();
        while (tuples.hasNext()) {
            Tuple next = (Tuple)tuples.next();
            for (String columnName : next.getColumnNames()) {
                tuplesAsList.add(next.get(columnName));
            }
        }
        return new NoSQLProcedureResultSetOutputImpl(tuplesAsList);
    }

    public boolean goToNext() {
        return false;
    }

    public void release() {
    }

    public boolean isResultSet() {
        return this.getCurrent().isResultSet();
    }
}

