/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.impl;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.ogm.compensation.ErrorHandler;
import org.hibernate.ogm.compensation.impl.ErrorHandlerEnabledTransactionCoordinatorBuilder;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.transaction.emulated.impl.EmulatedLocalTransactionCoordinatorBuilder;
import org.hibernate.ogm.transaction.jta.impl.RollbackOnCommitFailureJtaTransactionCoordinatorBuilder;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.resource.transaction.internal.TransactionCoordinatorBuilderInitiator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class OgmTransactionCoordinatorBuilderInitiator
implements StandardServiceInitiator<TransactionCoordinatorBuilder> {
    public static final OgmTransactionCoordinatorBuilderInitiator INSTANCE = new OgmTransactionCoordinatorBuilderInitiator();

    private OgmTransactionCoordinatorBuilderInitiator() {
    }

    public Class<TransactionCoordinatorBuilder> getServiceInitiated() {
        return TransactionCoordinatorBuilder.class;
    }

    public TransactionCoordinatorBuilder initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        TransactionCoordinatorBuilder defaultBuilder;
        Object builder = null;
        DatastoreProvider datastoreProvider = (DatastoreProvider)registry.getService(DatastoreProvider.class);
        TransactionCoordinatorBuilder customBuilder = datastoreProvider.getTransactionCoordinatorBuilder(defaultBuilder = TransactionCoordinatorBuilderInitiator.INSTANCE.initiateService(configurationValues, registry));
        builder = customBuilder != null && customBuilder != defaultBuilder ? customBuilder : (defaultBuilder.isJta() ? defaultBuilder : (datastoreProvider.allowsTransactionEmulation() ? new EmulatedLocalTransactionCoordinatorBuilder(defaultBuilder) : new RollbackOnCommitFailureJtaTransactionCoordinatorBuilder(this.getDefaultBuilder(registry, "jta"))));
        return this.decorateWithErrorHandlerIfNeeded(configurationValues, registry, (TransactionCoordinatorBuilder)builder);
    }

    private TransactionCoordinatorBuilder getDefaultBuilder(ServiceRegistryImplementor registry, String strategy) {
        return (TransactionCoordinatorBuilder)((StrategySelector)registry.getService(StrategySelector.class)).resolveStrategy(TransactionCoordinatorBuilder.class, (Object)strategy);
    }

    private TransactionCoordinatorBuilder decorateWithErrorHandlerIfNeeded(Map configurationValues, ServiceRegistryImplementor registry, TransactionCoordinatorBuilder builder) {
        ErrorHandler errorHandler = this.getErrorHandler(configurationValues, registry);
        return errorHandler != null ? new ErrorHandlerEnabledTransactionCoordinatorBuilder(builder, errorHandler) : builder;
    }

    private ErrorHandler getErrorHandler(Map<?, ?> configurationValues, ServiceRegistryImplementor registry) {
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues, (ClassLoaderService)registry.getService(ClassLoaderService.class));
        return (ErrorHandler)propertyReader.property("hibernate.ogm.error_handler", ErrorHandler.class).instantiate().getValue();
    }
}

