/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.descriptor.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.impl.GridValueExtractor;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class StringMappedGridExtractor<J>
implements GridValueExtractor<J> {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final GridTypeDescriptor gridTypeDescriptor;
    private final JavaTypeDescriptor<J> javaTypeDescriptor;

    public StringMappedGridExtractor(JavaTypeDescriptor<J> javaTypeDescriptor, GridTypeDescriptor gridTypeDescriptor) {
        this.gridTypeDescriptor = gridTypeDescriptor;
        this.javaTypeDescriptor = javaTypeDescriptor;
    }

    @Override
    public J extract(Tuple resultset, String name) {
        String result = (String)resultset.get(name);
        if (result == null) {
            log.tracef("found [null] as column [$s]", name);
            return null;
        }
        Object resultJ = this.javaTypeDescriptor.fromString(result);
        if (log.isTraceEnabled()) {
            log.tracef("found [$s] as column [$s]", this.javaTypeDescriptor.extractLoggableRepresentation(resultJ), name);
        }
        return (J)resultJ;
    }
}

