/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.impl;

import org.hibernate.MappingException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.impl.AbstractGenericBasicType;
import org.hibernate.type.descriptor.converter.AttributeConverterMutabilityPlanImpl;
import org.hibernate.type.descriptor.converter.AttributeConverterTypeAdapter;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class AttributeConverterGridTypeAdaptor<T>
extends AbstractGenericBasicType<T> {
    private final MutabilityPlan<T> mutabilityPlan;
    private final AttributeConverterTypeAdapter<T> ormAdapter;
    private final String description;

    public AttributeConverterGridTypeAdaptor(AttributeConverterTypeAdapter<T> ormAdapter, GridTypeDescriptor gridTypeDescriptorAdapter) {
        super(gridTypeDescriptorAdapter, ormAdapter.getJavaTypeDescriptor());
        this.ormAdapter = ormAdapter;
        this.mutabilityPlan = ormAdapter.getJavaTypeDescriptor().getMutabilityPlan().isMutable() ? new AttributeConverterMutabilityPlanImpl(ormAdapter.getAttributeConverter()) : ImmutableMutabilityPlan.INSTANCE;
        this.description = "GridType version of " + ormAdapter.toString();
    }

    @Override
    public int getColumnSpan(Mapping mapping) throws MappingException {
        return this.ormAdapter.getColumnSpan(mapping);
    }

    @Override
    public String getName() {
        return this.ormAdapter.getName();
    }

    @Override
    protected boolean registerUnderJavaType() {
        return false;
    }

    @Override
    protected MutabilityPlan<T> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    public String toString() {
        return this.description;
    }
}

