/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.impl;

import java.util.Arrays;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.impl.GridTypeDelegatingToCoreType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.hibernate.type.Type;

public class ComponentType
extends GridTypeDelegatingToCoreType
implements GridType {
    private final org.hibernate.type.ComponentType componentType;
    private final int propertySpan;
    private final GridType[] propertyTypes;

    public ComponentType(org.hibernate.type.ComponentType componentType, TypeTranslator typeTranslator) {
        super((Type)componentType);
        this.componentType = componentType;
        this.propertySpan = componentType.getPropertyNames().length;
        Type[] coreSubtypes = componentType.getSubtypes();
        this.propertyTypes = new GridType[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            this.propertyTypes[i] = typeTranslator.getType(coreSubtypes[i]);
        }
    }

    @Override
    public Object nullSafeGet(Tuple rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return this.resolve(this.hydrate(rs, names, session, owner), session, owner);
    }

    @Override
    public Object nullSafeGet(Tuple rs, String name, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    @Override
    public void nullSafeSet(Tuple resultset, Object value, String[] names, boolean[] settable, SharedSessionContractImplementor session) throws HibernateException {
        Object[] subvalues = this.nullSafeGetValues(value, this.componentType.getEntityMode());
        int columnCurrentIndex = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            int columnSpanOnProperty = this.propertyTypes[i].getColumnSpan((Mapping)session.getFactory());
            if (columnSpanOnProperty != 0) {
                if (columnSpanOnProperty == 1) {
                    if (settable[columnCurrentIndex]) {
                        this.propertyTypes[i].nullSafeSet(resultset, subvalues[i], new String[]{names[columnCurrentIndex]}, session);
                    }
                } else {
                    boolean[] subsettable = new boolean[columnSpanOnProperty];
                    System.arraycopy(settable, columnCurrentIndex, subsettable, 0, columnSpanOnProperty);
                    String[] subnames = new String[columnSpanOnProperty];
                    System.arraycopy(names, columnCurrentIndex, subnames, 0, columnSpanOnProperty);
                    this.propertyTypes[i].nullSafeSet(resultset, subvalues[i], subnames, subsettable, session);
                }
            }
            columnCurrentIndex += columnSpanOnProperty;
        }
    }

    @Override
    public void nullSafeSet(Tuple resultset, Object value, String[] names, SharedSessionContractImplementor session) throws HibernateException {
        boolean[] trueSettable = new boolean[names.length];
        Arrays.fill(trueSettable, true);
        this.nullSafeSet(resultset, value, names, trueSettable, session);
    }

    @Override
    public Object hydrate(Tuple rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        int begin = 0;
        boolean notNull = false;
        Object[] values = new Object[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            int length = this.propertyTypes[i].getColumnSpan((Mapping)session.getFactory());
            String[] range = ArrayHelper.slice(names, begin, length);
            Object val = this.propertyTypes[i].hydrate(rs, range, session, owner);
            if (val == null) {
                if (this.componentType.isKey()) {
                    return null;
                }
            } else {
                notNull = true;
            }
            values[i] = val;
            begin += length;
        }
        return notNull ? values : null;
    }

    @Override
    public Object convertToBackendType(Object value, SessionFactoryImplementor sessionFactory) {
        Tuple tuple = new Tuple();
        this.nullSafeSet(tuple, value, new String[]{"dummy"}, (SharedSessionContractImplementor)((SessionImplementor)null));
        return tuple.get("dummy");
    }

    private Object[] nullSafeGetValues(Object value, EntityMode entityMode) throws HibernateException {
        if (value == null) {
            return new Object[this.propertySpan];
        }
        return this.componentType.getPropertyValues(value, entityMode);
    }
}

