/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.impl;

import java.sql.Timestamp;
import java.util.Date;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.descriptor.impl.BasicGridBinder;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.impl.GridValueBinder;
import org.hibernate.ogm.type.descriptor.impl.GridValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class TimestampGridTypeDescriptor
implements GridTypeDescriptor {
    public static final TimestampGridTypeDescriptor INSTANCE = new TimestampGridTypeDescriptor();

    @Override
    public <X> GridValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicGridBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(Tuple resultset, X value, String[] names, WrapperOptions options) {
                Timestamp unwrap = (Timestamp)javaTypeDescriptor.unwrap(value, Timestamp.class, options);
                resultset.put(names[0], unwrap);
            }
        };
    }

    @Override
    public <X> GridValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new GridValueExtractor<X>(){

            @Override
            public X extract(Tuple resultset, String name) {
                Date document = (Date)resultset.get(name);
                if (document == null) {
                    return null;
                }
                return javaTypeDescriptor.wrap((Object)new Timestamp(document.getTime()), null);
            }
        };
    }
}

