/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.loader.impl.OgmLoadingContext;
import org.hibernate.ogm.loader.impl.TupleBasedEntityLoader;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.type.Type;

public class CustomLoaderHelper {
    public static List<Object> listOfEntities(SharedSessionContractImplementor session, Type[] resultTypes, ClosableIterator<Tuple> tuples) {
        Class returnedClass = resultTypes[0].getReturnedClass();
        TupleBasedEntityLoader loader = CustomLoaderHelper.getLoader(session, returnedClass);
        OgmLoadingContext ogmLoadingContext = new OgmLoadingContext();
        ogmLoadingContext.setTuples(CustomLoaderHelper.getTuplesAsList(tuples));
        return loader.loadEntitiesFromTuples(session, LockOptions.NONE, ogmLoadingContext);
    }

    public static List<Object> listOfEntities(SharedSessionContractImplementor session, Class<?> returnedClass, ClosableIterator<Tuple> tuples) {
        TupleBasedEntityLoader loader = CustomLoaderHelper.getLoader(session, returnedClass);
        OgmLoadingContext ogmLoadingContext = new OgmLoadingContext();
        ogmLoadingContext.setTuples(CustomLoaderHelper.getTuplesAsList(tuples));
        return loader.loadEntitiesFromTuples(session, LockOptions.NONE, ogmLoadingContext);
    }

    private static List<Tuple> getTuplesAsList(ClosableIterator<Tuple> tuples) {
        ArrayList<Tuple> tuplesAsList = new ArrayList<Tuple>();
        while (tuples.hasNext()) {
            tuplesAsList.add((Tuple)tuples.next());
        }
        return tuplesAsList;
    }

    public static TupleBasedEntityLoader getLoader(SharedSessionContractImplementor session, Class<?> entityClass) {
        OgmEntityPersister persister = (OgmEntityPersister)session.getFactory().getMetamodel().entityPersister(entityClass.getName());
        TupleBasedEntityLoader loader = (TupleBasedEntityLoader)persister.getAppropriateLoader(LockOptions.READ, session);
        return loader;
    }
}

