/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.persistence.PersistenceException;
import javax.transaction.SystemException;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransactionException;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.exception.EntityAlreadyExistsException;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.options.spi.AnnotationConverter;
import org.hibernate.ogm.util.impl.ClassObjectFormatter;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.service.spi.ServiceException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String version = "OGM000001: Hibernate OGM %1$s";
    private static final String persistenceXmlNotFoundInClassPath = "OGM000002: Could not find any META-INF/persistence.xml file in the classpath. Unable to build Persistence Unit %1$s";
    private static final String cannotInstantiateGridDialect = "OGM000011: Cannot instantiate GridDialect class [%1$s]";
    private static final String gridDialectHasNoProperConstructor = "OGM000014: %1$s has no constructor accepting org.hibernate.ogm.datastore.spi.DatastoreProvider";
    private static final String unexpectedDatastoreProvider = "OGM000015: Expected DatastoreProvider %2$s but found %1$s";
    private static final String useDatastoreProvider = "OGM000016: NoSQL Datastore provider: %1$s";
    private static final String useGridDialect = "OGM000017: Grid Dialect: %1$s";
    private static final String jtaTransactionBeginFailed = "OGM000018: JTA transaction begin failed";
    private static final String jtaCommitFailed = "OGM000019: JTA transaction commit failed";
    private static final String jtaRollbackFailed = "OGM000020: JTA transaction rollback failed";
    private static final String unableToMarkTransactionForRollback = "OGM000021: Unable to mark JTA transaction for rollback";
    private static final String jtaCouldNotDetermineStatus = "OGM000022: Could not determine transaction status";
    private static final String unableToSetTimeout = "OGM000023: Unable to set transaction timeout to '%1$s'";
    private static final String querySyntaxException = "OGM000024: Syntax error in query: [%1$s]";
    private static final String interruptedBatchIndexing = "OGM000025: Batch indexing was interrupted";
    private static final String illegalDiscrimantorType = "OGM000026: Illegal discriminator type: '%1$s'";
    private static final String unableToConvertStringToDiscriminator = "OGM000027: Could not convert string to discriminator object";
    private static final String createdQuery = "OGM000028: Created query object '%2$s' from HQL/JP-QL query '%1$s'.";
    private static final String unsupportedIndexerConfigurationOption = "OGM000031: OgmMassIndexer doesn't support the configuration option '%s'. Its setting will be ignored.";
    private static final String mappingSubtypeNotInterface = "OGM000032: Unable to support mapping subtypes that are not interfaces: %1$s";
    private static final String cannotCreateNewProxyInstance = "OGM000033: Unable to create new proxy instance";
    private static final String cannotConvertAnnotation = "OGM000034: Annotation cannot be converted using %1$s";
    private static final String unableToLoadContext = "OGM000036: Unable to load %1$s method from %2$s ";
    private static final String cannotCreateGlobalContextProxy = "OGM000037: Unable to create global context proxy for type %1$s";
    private static final String cannotCreateEntityContextProxy = "OGM000038: Unable to create entity context proxy for type %1$s";
    private static final String cannotCreatePropertyContextProxy = "OGM000039: Unable to create property context proxy for type %1$s";
    private static final String getPropertyDoesNotExistException = "OGM000041: The given propery %1$s#%2$s with element type %3$s does not exist.";
    private static final String getUnsupportedElementTypeException = "OGM000042: The given element type %1$s is neither FIELD nor METHOD.";
    private static final String unableToInstantiateType = "OGM000043: Cannot instantiate type %1$s. Does it define a default constructor?";
    private static final String unableToLoadClass = "OGM000044: Cannot load class %2$s specified via configuration property '%1$s'";
    private static final String unexpectedClassType = "OGM000045: Type %2$s specified via configuration property '%1$s' is not a sub-type of expected type %3$s";
    private static final String unexpectedInstanceType = "OGM000046: Object %2$s of type %3$s specified via configuration property '%1$s' is not of the expected type %4$s";
    private static final String ambigiousOptionConfiguration = "OGM000047: Either an option configurator may be specified via configuration property '%1$s' or OgmConfiguration#configureOptions() may be called, but not both at the same time.";
    private static final String unknownAssociationStorageStrategy = "OGM000048: Unknown association storage strategy: [%s]. Supported values are: %s";
    private static final String illegalPortValue = "OGM000049: The value set for the configuration property 'hibernate.ogm.datastore.port' must be a number between 1 and 65535. Found '%s'.";
    private static final String notAnInteger = "OGM000050: The value set for the configuration property '%1$s' must be an integer number. Found '%2$s'.";
    private static final String unknownEnumerationValue = "OGM000051: Unknown value given for configuration property '%1$s'; Found '%2$s', but supported values are: %3$s";
    private static final String missingConfigurationProperty = "OGM000052: Missing value for property '%s'";
    private static final String unsupportedPropertyType = "OGM000053: Value of unsupported type given for configuration property '%1$s': '%2$s'";
    private static final String closedOperationQueue = "OGM000054: It is not possible to add or poll operations from a closed queue";
    private static final String invalidConfigurationUrl = "OGM000055: Invalid URL given for configuration property '%1$s': %2$s; The specified resource could not be found.";
    private static final String couldNotRetrieveEntityForRetrievalOfGeneratedProperties = "OGM000056: Unable to load record for retrieval of generated properties; Entity type: %1$s, id: %2$s";
    private static final String mustNotBeNull = "OGM000057: '%s' must not be null";
    private static final String parameterMustNotBeNull = "OGM000058: Parameter '%s' must not be null";
    private static final String unableToFindGridType = "OGM000059: Unable to find a GridType for %s";
    private static final String dialectDoesNotSupportSequences = "OGM000060: Sequence id generator used for entity '%2$s' is not supported by grid dialect %1$s, falling back to table-based id generation. Consider to use @TableGenerator rather than @SequenceGenerator.";
    private static final String catalogOptionNotSupportedForTableGenerator = "OGM000061: The option '@TableGenerator#catalog()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    private static final String schemaOptionNotSupportedForTableGenerator = "OGM000062: The option '@TableGenerator#schema()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    private static final String catalogOptionNotSupportedForSequenceGenerator = "OGM000063: The option '@SequenceGenerator#catalog()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    private static final String schemaOptionNotSupportedForSequenceGenerator = "OGM000064: The option '@SequenceGenerator#schema()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    private static final String getIdentityGenerationStrategyNotSupportedException = "OGM000065: Id generation strategy IDENTITY configured for entity %1$s is not supported by the current grid dialect.";
    private static final String usingNonAtomicOptimisticLocking = "OGM000066: Entity type %s uses an optimistic locking strategy which is not supported by the current grid dialect in an atomic manner. There will be two datastore round-trips for version checking and updating the data.";
    private static final String mustNotInsertSameEntityTwice = "OGM000067: Trying to insert an already existing entity: %s";
    private static final String couldNotConfigureProperty = "OGM000068: Could not configure property %1$s#%2$s";
    private static final String unsupportedLockMode = "OGM000069: Grid dialect %1$s does not support lock mode %2$s";
    private static final String noValidDatastoreProviderShortName = "OGM000070: '%1$s' is no valid datastore provider short name. Valid values are: %2$s";
    private static final String unableToStartDatastoreProvider = "OGM000071: Unable to start datastore provider";
    private static final String unableToConfigureDatastoreProvider = "OGM000072: Unable to configure datastore provider";
    private static final String cannotLoadLuceneParserBackend = "OGM000073: Couldn't load the Lucene-based query parser backend. Make sure the dependency org.hibernate.hql:hibernate-hql-lucene is part of the classpath.";
    private static final String unableToCloseSessionButSwallowingError = "OGM000074: Could not close session; swallowing exception as transaction completed";
    private static final String jbossTransactionManagerDetected = "OGM000075: JBoss Transaction Manager (com.arjuna.ats.jta.TransactionManager) detected on classpath. Using JBossStandAloneJtaPlatform as JTAPlatform implementation";
    private static final String noJtaPlatformDetected = "OGM000076: No explicit or implicit defined JTAPlatform. Using NoJtaPlatform";
    private static final String parameterSringMustNotBeEmpty = "OGM000077: Parameter '%s' must not be an empty string";
    private static final String getUnknownAliasException = "OGM000078: Unrecognized alias in query:  %s";
    private static final String unableToParseHost = "OGM000079: Unable to parse hibernate.ogm.datastore.host %s\nProperty should be a comma separated list of host:port\ne.g. www.example.com, www2.example.com:123, 192.0.2.1, 192.0.2.2:123, 2001:db8::ff00:42:8329, [2001:db8::ff00:42:8329]:123";
    private static final String errorOnEntityBatchLoad = "OGM000080: Could not load an entity batch: %s";
    private static final String notALong = "OGM000081: The value set for the configuration property '%1$s' must be a long number. Found '%2$s'.";
    private static final String entityTupleNotFound = "OGM000082: The entity at the inverse side of the association '%1$s' cannot be found in the session: %2$s";
    private static final String failureWhenUsingAttributeConverter = "OGM000083: Failure when using JPA AttributeConverter [%1$s]. Is the datastore type of the converter a supported type for your datastore?";
    private static final String cannotFindTypeForAttributeConverter = "OGM000084: Unable to find basic type support for [%2$s] when using JPA AttributeConverter [%1$s].Is the datastore type of the converter a supported type for your datastore?";
    private static final String cannotFindEntityEntryForEntity = "OGM000085: Unable to find an entity entry for the entity '%1$s'";
    private static final String transactionIdIsNotAvailable = "OGM000086: Transaction identifier not available";
    private static final String tupleContextNotAvailable = "OGM000087: The tuple context is not available, probably because we are dealing with more than a single entity type";
    private static final String usingDeprecatedDatastoreProviderName = "OGM000088: Configuration is referring to deprecated datastore provider name '%1$s'. Please use the new form '%2$s' instead.";
    private static final String queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass = "OGM000089: %1$s does not support queries on polymorphic entities using TABLE_PER_CLASS inheritance strategy. You should try using SINGLE_TABLE instead. Entities: %2$s";
    private static final String multipleEntitiesOutputNotSupported = "OGM000090: Returning multiple entities is not supported. Procedure '%1$s' expects results of type %2$s";
    private static final String addEntityNotAllowedInNativeQueriesUsingProjection = "OGM000091: Projection and addEntity are not allowed in the same query on <%1$s> %2$s";
    private static final String cannotExecuteStoredProcedure = "OGM000092: Cannot execute stored procedure '%s'.";
    private static final String procedureWithResolvedNameDoesNotExist = "OGM000093: Procedure with resolved name '%s' does not exist.";
    private static final String dialectDoesNotSupportPositionalParametersForStoredProcedures = "OGM000094: Dialect %s does not support positional parameters when calling stored procedures";
    private static final String cannotSetStoredProcedureParameter = "OGM000095: Cannot set stored procedure '%s' parameter '%s' with value '%s'.";
    private static final String cannotExtractStoredProcedureResultSet = "OGM000096: Cannot extract stored procedure '%s' result set '%s'.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void version(String versionString) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.version$str(), (Object)versionString);
    }

    protected String version$str() {
        return version;
    }

    @Override
    public final void persistenceXmlNotFoundInClassPath(String unitName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.persistenceXmlNotFoundInClassPath$str(), (Object)unitName);
    }

    protected String persistenceXmlNotFoundInClassPath$str() {
        return persistenceXmlNotFoundInClassPath;
    }

    protected String cannotInstantiateGridDialect$str() {
        return cannotInstantiateGridDialect;
    }

    @Override
    public final HibernateException cannotInstantiateGridDialect(Class<?> dialectClass, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotInstantiateGridDialect$str(), new ClassObjectFormatter(dialectClass)), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String gridDialectHasNoProperConstructor$str() {
        return gridDialectHasNoProperConstructor;
    }

    @Override
    public final HibernateException gridDialectHasNoProperConstructor(Class<?> dialectClass) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.gridDialectHasNoProperConstructor$str(), new ClassObjectFormatter(dialectClass)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedDatastoreProvider$str() {
        return unexpectedDatastoreProvider;
    }

    @Override
    public final HibernateException unexpectedDatastoreProvider(Class<?> found, Class<?> expected) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unexpectedDatastoreProvider$str(), new ClassObjectFormatter(found), new ClassObjectFormatter(expected)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void useDatastoreProvider(Class<?> datastoreProviderClass) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.useDatastoreProvider$str(), (Object)new ClassObjectFormatter(datastoreProviderClass));
    }

    protected String useDatastoreProvider$str() {
        return useDatastoreProvider;
    }

    @Override
    public final void useGridDialect(Class<?> gridDialectClass) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.useGridDialect$str(), (Object)new ClassObjectFormatter(gridDialectClass));
    }

    protected String useGridDialect$str() {
        return useGridDialect;
    }

    protected String jtaTransactionBeginFailed$str() {
        return jtaTransactionBeginFailed;
    }

    @Override
    public final TransactionException jtaTransactionBeginFailed(Exception e) {
        TransactionException result = new TransactionException(String.format(this.getLoggingLocale(), this.jtaTransactionBeginFailed$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaCommitFailed$str() {
        return jtaCommitFailed;
    }

    @Override
    public final TransactionException jtaCommitFailed(Exception e) {
        TransactionException result = new TransactionException(String.format(this.getLoggingLocale(), this.jtaCommitFailed$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaRollbackFailed$str() {
        return jtaRollbackFailed;
    }

    @Override
    public final TransactionException jtaRollbackFailed(Exception e) {
        TransactionException result = new TransactionException(String.format(this.getLoggingLocale(), this.jtaRollbackFailed$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToMarkTransactionForRollback$str() {
        return unableToMarkTransactionForRollback;
    }

    @Override
    public final TransactionException unableToMarkTransactionForRollback(Exception e) {
        TransactionException result = new TransactionException(String.format(this.getLoggingLocale(), this.unableToMarkTransactionForRollback$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaCouldNotDetermineStatus$str() {
        return jtaCouldNotDetermineStatus;
    }

    @Override
    public final TransactionException jtaCouldNotDetermineStatus(SystemException se) {
        TransactionException result = new TransactionException(String.format(this.getLoggingLocale(), this.jtaCouldNotDetermineStatus$str(), new Object[0]), (Throwable)se);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSetTimeout$str() {
        return unableToSetTimeout;
    }

    @Override
    public final TransactionException unableToSetTimeout(SystemException se, int timeout) {
        TransactionException result = new TransactionException(String.format(this.getLoggingLocale(), this.unableToSetTimeout$str(), timeout), (Throwable)se);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String querySyntaxException$str() {
        return querySyntaxException;
    }

    @Override
    public final HibernateException querySyntaxException(Exception qse, String queryString) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.querySyntaxException$str(), queryString), (Throwable)qse);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }

    protected String illegalDiscrimantorType$str() {
        return illegalDiscrimantorType;
    }

    @Override
    public final HibernateException illegalDiscrimantorType(String name) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.illegalDiscrimantorType$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertStringToDiscriminator$str() {
        return unableToConvertStringToDiscriminator;
    }

    @Override
    public final HibernateException unableToConvertStringToDiscriminator(Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToConvertStringToDiscriminator$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void createdQuery(String hqlQuery, Object queryObject) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.createdQuery$str(), (Object)hqlQuery, queryObject);
    }

    protected String createdQuery$str() {
        return createdQuery;
    }

    @Override
    public final void unsupportedIndexerConfigurationOption(String optionName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsupportedIndexerConfigurationOption$str(), (Object)optionName);
    }

    protected String unsupportedIndexerConfigurationOption$str() {
        return unsupportedIndexerConfigurationOption;
    }

    protected String mappingSubtypeNotInterface$str() {
        return mappingSubtypeNotInterface;
    }

    @Override
    public final HibernateException mappingSubtypeNotInterface(Class<?> mappingType) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.mappingSubtypeNotInterface$str(), new ClassObjectFormatter(mappingType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateNewProxyInstance$str() {
        return cannotCreateNewProxyInstance;
    }

    @Override
    public final HibernateException cannotCreateNewProxyInstance(Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotCreateNewProxyInstance$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertAnnotation$str() {
        return cannotConvertAnnotation;
    }

    @Override
    public final HibernateException cannotConvertAnnotation(Class<? extends AnnotationConverter<?>> converterClass, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotConvertAnnotation$str(), new ClassObjectFormatter(converterClass)), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadContext$str() {
        return unableToLoadContext;
    }

    @Override
    public final HibernateException unableToLoadContext(String methodName, Class<?> contextClass, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToLoadContext$str(), methodName, new ClassObjectFormatter(contextClass)), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateGlobalContextProxy$str() {
        return cannotCreateGlobalContextProxy;
    }

    @Override
    public final HibernateException cannotCreateGlobalContextProxy(Class<?> contextClass, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotCreateGlobalContextProxy$str(), new ClassObjectFormatter(contextClass)), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateEntityContextProxy$str() {
        return cannotCreateEntityContextProxy;
    }

    @Override
    public final HibernateException cannotCreateEntityContextProxy(Class<?> contextClass, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotCreateEntityContextProxy$str(), new ClassObjectFormatter(contextClass)), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreatePropertyContextProxy$str() {
        return cannotCreatePropertyContextProxy;
    }

    @Override
    public final HibernateException cannotCreatePropertyContextProxy(Class<?> contextClass, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotCreatePropertyContextProxy$str(), new ClassObjectFormatter(contextClass)), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getPropertyDoesNotExistException$str() {
        return getPropertyDoesNotExistException;
    }

    @Override
    public final HibernateException getPropertyDoesNotExistException(String typeName, String property, ElementType elementType) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.getPropertyDoesNotExistException$str(), new Object[]{typeName, property, elementType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnsupportedElementTypeException$str() {
        return getUnsupportedElementTypeException;
    }

    @Override
    public final HibernateException getUnsupportedElementTypeException(ElementType elementType) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.getUnsupportedElementTypeException$str(), new Object[]{elementType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateType$str() {
        return unableToInstantiateType;
    }

    @Override
    public final HibernateException unableToInstantiateType(Class<?> clazz, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToInstantiateType$str(), new ClassObjectFormatter(clazz)), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadClass$str() {
        return unableToLoadClass;
    }

    @Override
    public final HibernateException unableToLoadClass(String propertyName, String className, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToLoadClass$str(), propertyName, className), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedClassType$str() {
        return unexpectedClassType;
    }

    @Override
    public final HibernateException unexpectedClassType(String propertyName, Class<?> clazz, Class<?> expectedClass) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unexpectedClassType$str(), propertyName, new ClassObjectFormatter(clazz), new ClassObjectFormatter(expectedClass)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedInstanceType$str() {
        return unexpectedInstanceType;
    }

    @Override
    public final HibernateException unexpectedInstanceType(String propertyName, String instance, Class<?> actualClass, Class<?> expectedClass) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unexpectedInstanceType$str(), propertyName, instance, new ClassObjectFormatter(actualClass), new ClassObjectFormatter(expectedClass)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambigiousOptionConfiguration$str() {
        return ambigiousOptionConfiguration;
    }

    @Override
    public final HibernateException ambigiousOptionConfiguration(String propertyName) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.ambigiousOptionConfiguration$str(), propertyName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAssociationStorageStrategy$str() {
        return unknownAssociationStorageStrategy;
    }

    @Override
    public final HibernateException unknownAssociationStorageStrategy(String databaseName, String supportedValues) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unknownAssociationStorageStrategy$str(), databaseName, supportedValues));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalPortValue$str() {
        return illegalPortValue;
    }

    @Override
    public final HibernateException illegalPortValue(int value) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.illegalPortValue$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notAnInteger$str() {
        return notAnInteger;
    }

    @Override
    public final HibernateException notAnInteger(String propertyName, String value) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.notAnInteger$str(), propertyName, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownEnumerationValue$str() {
        return unknownEnumerationValue;
    }

    @Override
    public final HibernateException unknownEnumerationValue(String propertyName, String value, String supportedValues) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unknownEnumerationValue$str(), propertyName, value, supportedValues));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingConfigurationProperty$str() {
        return missingConfigurationProperty;
    }

    @Override
    public final HibernateException missingConfigurationProperty(String propertyName) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.missingConfigurationProperty$str(), propertyName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedPropertyType$str() {
        return unsupportedPropertyType;
    }

    @Override
    public final HibernateException unsupportedPropertyType(String propertyName, String value) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unsupportedPropertyType$str(), propertyName, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String closedOperationQueue$str() {
        return closedOperationQueue;
    }

    @Override
    public final HibernateException closedOperationQueue() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.closedOperationQueue$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConfigurationUrl$str() {
        return invalidConfigurationUrl;
    }

    @Override
    public final HibernateException invalidConfigurationUrl(String propertyName, String url) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.invalidConfigurationUrl$str(), propertyName, url));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotRetrieveEntityForRetrievalOfGeneratedProperties$str() {
        return couldNotRetrieveEntityForRetrievalOfGeneratedProperties;
    }

    @Override
    public final HibernateException couldNotRetrieveEntityForRetrievalOfGeneratedProperties(String entityType, Serializable id) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.couldNotRetrieveEntityForRetrievalOfGeneratedProperties$str(), entityType, id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustNotBeNull$str() {
        return mustNotBeNull;
    }

    @Override
    public final IllegalArgumentException mustNotBeNull(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mustNotBeNull$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String parameterMustNotBeNull$str() {
        return parameterMustNotBeNull;
    }

    @Override
    public final IllegalArgumentException parameterMustNotBeNull(String parameterName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.parameterMustNotBeNull$str(), parameterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToFindGridType$str() {
        return unableToFindGridType;
    }

    @Override
    public final HibernateException unableToFindGridType(String typeName) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToFindGridType$str(), typeName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void dialectDoesNotSupportSequences(Class<?> dialectClass, String entityName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.dialectDoesNotSupportSequences$str(), (Object)new ClassObjectFormatter(dialectClass), (Object)entityName);
    }

    protected String dialectDoesNotSupportSequences$str() {
        return dialectDoesNotSupportSequences;
    }

    @Override
    public final void catalogOptionNotSupportedForTableGenerator(String catalogName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.catalogOptionNotSupportedForTableGenerator$str(), (Object)catalogName);
    }

    protected String catalogOptionNotSupportedForTableGenerator$str() {
        return catalogOptionNotSupportedForTableGenerator;
    }

    @Override
    public final void schemaOptionNotSupportedForTableGenerator(String schemaName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.schemaOptionNotSupportedForTableGenerator$str(), (Object)schemaName);
    }

    protected String schemaOptionNotSupportedForTableGenerator$str() {
        return schemaOptionNotSupportedForTableGenerator;
    }

    @Override
    public final void catalogOptionNotSupportedForSequenceGenerator(String catalogName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.catalogOptionNotSupportedForSequenceGenerator$str(), (Object)catalogName);
    }

    protected String catalogOptionNotSupportedForSequenceGenerator$str() {
        return catalogOptionNotSupportedForSequenceGenerator;
    }

    @Override
    public final void schemaOptionNotSupportedForSequenceGenerator(String schemaName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.schemaOptionNotSupportedForSequenceGenerator$str(), (Object)schemaName);
    }

    protected String schemaOptionNotSupportedForSequenceGenerator$str() {
        return schemaOptionNotSupportedForSequenceGenerator;
    }

    protected String getIdentityGenerationStrategyNotSupportedException$str() {
        return getIdentityGenerationStrategyNotSupportedException;
    }

    @Override
    public final HibernateException getIdentityGenerationStrategyNotSupportedException(String entityName) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.getIdentityGenerationStrategyNotSupportedException$str(), entityName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void usingNonAtomicOptimisticLocking(String entityName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingNonAtomicOptimisticLocking$str(), (Object)entityName);
    }

    protected String usingNonAtomicOptimisticLocking$str() {
        return usingNonAtomicOptimisticLocking;
    }

    protected String mustNotInsertSameEntityTwice$str() {
        return mustNotInsertSameEntityTwice;
    }

    @Override
    public final EntityAlreadyExistsException mustNotInsertSameEntityTwice(String primaryKey, Exception taee) {
        EntityAlreadyExistsException result = new EntityAlreadyExistsException(String.format(this.getLoggingLocale(), this.mustNotInsertSameEntityTwice$str(), primaryKey), taee);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotConfigureProperty$str() {
        return couldNotConfigureProperty;
    }

    @Override
    public final HibernateException couldNotConfigureProperty(String entityName, String string, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.couldNotConfigureProperty$str(), entityName, string), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedLockMode$str() {
        return unsupportedLockMode;
    }

    @Override
    public final HibernateException unsupportedLockMode(Class<? extends GridDialect> dialectClass, LockMode lockMode) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unsupportedLockMode$str(), new ClassObjectFormatter(dialectClass), lockMode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void noValidDatastoreProviderShortName(String providerName, String validProviderNames) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noValidDatastoreProviderShortName$str(), (Object)providerName, (Object)validProviderNames);
    }

    protected String noValidDatastoreProviderShortName$str() {
        return noValidDatastoreProviderShortName;
    }

    protected String unableToStartDatastoreProvider$str() {
        return unableToStartDatastoreProvider;
    }

    @Override
    public final ServiceException unableToStartDatastoreProvider(Exception e) {
        ServiceException result = new ServiceException(String.format(this.getLoggingLocale(), this.unableToStartDatastoreProvider$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConfigureDatastoreProvider$str() {
        return unableToConfigureDatastoreProvider;
    }

    @Override
    public final ServiceException unableToConfigureDatastoreProvider(Exception e) {
        ServiceException result = new ServiceException(String.format(this.getLoggingLocale(), this.unableToConfigureDatastoreProvider$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotLoadLuceneParserBackend$str() {
        return cannotLoadLuceneParserBackend;
    }

    @Override
    public final HibernateException cannotLoadLuceneParserBackend(Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotLoadLuceneParserBackend$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unableToCloseSessionButSwallowingError(Exception e) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)e, this.unableToCloseSessionButSwallowingError$str(), new Object[0]);
    }

    protected String unableToCloseSessionButSwallowingError$str() {
        return unableToCloseSessionButSwallowingError;
    }

    @Override
    public final void jbossTransactionManagerDetected() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jbossTransactionManagerDetected$str(), new Object[0]);
    }

    protected String jbossTransactionManagerDetected$str() {
        return jbossTransactionManagerDetected;
    }

    @Override
    public final void noJtaPlatformDetected() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.noJtaPlatformDetected$str(), new Object[0]);
    }

    protected String noJtaPlatformDetected$str() {
        return noJtaPlatformDetected;
    }

    protected String parameterSringMustNotBeEmpty$str() {
        return parameterSringMustNotBeEmpty;
    }

    @Override
    public final IllegalArgumentException parameterSringMustNotBeEmpty(String parameterName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.parameterSringMustNotBeEmpty$str(), parameterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnknownAliasException$str() {
        return getUnknownAliasException;
    }

    @Override
    public final HibernateException getUnknownAliasException(String text) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.getUnknownAliasException$str(), text));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToParseHost$str() {
        return unableToParseHost;
    }

    @Override
    public final HibernateException unableToParseHost(String text) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToParseHost$str(), text));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorOnEntityBatchLoad$str() {
        return errorOnEntityBatchLoad;
    }

    @Override
    public final HibernateException errorOnEntityBatchLoad(String contextualInfo, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.errorOnEntityBatchLoad$str(), contextualInfo), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notALong$str() {
        return notALong;
    }

    @Override
    public final HibernateException notALong(String propertyName, String value) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.notALong$str(), propertyName, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String entityTupleNotFound$str() {
        return entityTupleNotFound;
    }

    @Override
    public final HibernateException entityTupleNotFound(String collectionRole, EntityKey entityKey) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.entityTupleNotFound$str(), collectionRole, entityKey));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failureWhenUsingAttributeConverter$str() {
        return failureWhenUsingAttributeConverter;
    }

    @Override
    public final PersistenceException failureWhenUsingAttributeConverter(Class<?> converterClass, Exception e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.failureWhenUsingAttributeConverter$str(), new ClassObjectFormatter(converterClass)), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindTypeForAttributeConverter$str() {
        return cannotFindTypeForAttributeConverter;
    }

    @Override
    public final PersistenceException cannotFindTypeForAttributeConverter(Class<?> converted, Class<?> databaseColumnJavaType) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotFindTypeForAttributeConverter$str(), new ClassObjectFormatter(converted), new ClassObjectFormatter(databaseColumnJavaType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindEntityEntryForEntity$str() {
        return cannotFindEntityEntryForEntity;
    }

    @Override
    public final PersistenceException cannotFindEntityEntryForEntity(Object entity) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotFindEntityEntryForEntity$str(), entity));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String transactionIdIsNotAvailable$str() {
        return transactionIdIsNotAvailable;
    }

    @Override
    public final HibernateException transactionIdIsNotAvailable() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.transactionIdIsNotAvailable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tupleContextNotAvailable$str() {
        return tupleContextNotAvailable;
    }

    @Override
    public final HibernateException tupleContextNotAvailable() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.tupleContextNotAvailable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void usingDeprecatedDatastoreProviderName(String deprecatedName, String newName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingDeprecatedDatastoreProviderName$str(), (Object)deprecatedName, (Object)newName);
    }

    protected String usingDeprecatedDatastoreProviderName$str() {
        return usingDeprecatedDatastoreProviderName;
    }

    protected String queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass$str() {
        return queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass;
    }

    @Override
    public final HibernateException queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass(String datastore, Collection<String> subclassEntityNames) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass$str(), datastore, subclassEntityNames));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleEntitiesOutputNotSupported$str() {
        return multipleEntitiesOutputNotSupported;
    }

    @Override
    public final HibernateException multipleEntitiesOutputNotSupported(String procedureName, Collection<?> synchronizedQuerySpaces) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.multipleEntitiesOutputNotSupported$str(), procedureName, synchronizedQuerySpaces));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String addEntityNotAllowedInNativeQueriesUsingProjection$str() {
        return addEntityNotAllowedInNativeQueriesUsingProjection;
    }

    @Override
    public final HibernateException addEntityNotAllowedInNativeQueriesUsingProjection(String table, String query) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.addEntityNotAllowedInNativeQueriesUsingProjection$str(), table, query));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotExecuteStoredProcedure$str() {
        return cannotExecuteStoredProcedure;
    }

    @Override
    public final HibernateException cannotExecuteStoredProcedure(String storedProcedureName, Throwable e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotExecuteStoredProcedure$str(), storedProcedureName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String procedureWithResolvedNameDoesNotExist$str() {
        return procedureWithResolvedNameDoesNotExist;
    }

    @Override
    public final HibernateException procedureWithResolvedNameDoesNotExist(String procedureName, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.procedureWithResolvedNameDoesNotExist$str(), procedureName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String dialectDoesNotSupportPositionalParametersForStoredProcedures$str() {
        return dialectDoesNotSupportPositionalParametersForStoredProcedures;
    }

    @Override
    public final HibernateException dialectDoesNotSupportPositionalParametersForStoredProcedures(Class<?> dialectClass) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.dialectDoesNotSupportPositionalParametersForStoredProcedures$str(), new ClassObjectFormatter(dialectClass)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotSetStoredProcedureParameter$str() {
        return cannotSetStoredProcedureParameter;
    }

    @Override
    public final HibernateException cannotSetStoredProcedureParameter(String storedProcedureName, String param, Object value, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotSetStoredProcedureParameter$str(), storedProcedureName, param, value), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotExtractStoredProcedureResultSet$str() {
        return cannotExtractStoredProcedureResultSet;
    }

    @Override
    public final HibernateException cannotExtractStoredProcedureResultSet(String storedProcedureName, Object resultSet, Exception e) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotExtractStoredProcedureResultSet$str(), storedProcedureName, resultSet), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

