/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class ReflectionHelper {
    private static final String PROPERTY_ACCESSOR_PREFIX_GET = "get";
    private static final String PROPERTY_ACCESSOR_PREFIX_IS = "is";
    private static final String PROPERTY_ACCESSOR_PREFIX_SET = "set";

    public static Map<String, Object> introspect(Object obj) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BeanInfo info = Introspector.getBeanInfo(obj.getClass());
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            Method reader = pd.getReadMethod();
            String name = pd.getName();
            if (reader == null || "class".equals(name)) continue;
            result.put(name, reader.invoke(obj, new Object[0]));
        }
        return result;
    }

    public static boolean propertyExists(Class<?> clazz, String property, ElementType elementType) {
        if (ElementType.FIELD.equals((Object)elementType)) {
            return ReflectionHelper.getDeclaredField(clazz, property) != null;
        }
        String capitalizedPropertyName = ReflectionHelper.capitalize(property);
        Method method = ReflectionHelper.getMethod(clazz, PROPERTY_ACCESSOR_PREFIX_GET + capitalizedPropertyName, new Class[0]);
        if (method != null && method.getReturnType() != Void.TYPE) {
            return true;
        }
        method = ReflectionHelper.getMethod(clazz, PROPERTY_ACCESSOR_PREFIX_IS + capitalizedPropertyName, new Class[0]);
        return method != null && method.getReturnType() == Boolean.TYPE;
    }

    public static String getPropertyName(Method method) {
        if (method.getParameterTypes().length == 0) {
            String methodName = method.getName();
            if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_GET) && method.getReturnType() != Void.TYPE) {
                return Introspector.decapitalize(methodName.substring(3));
            }
            if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_IS) && method.getReturnType() == Boolean.TYPE) {
                return Introspector.decapitalize(methodName.substring(2));
            }
        }
        return null;
    }

    public static void setField(Object object, String field, Object value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Method m = clazz.getMethod(PROPERTY_ACCESSOR_PREFIX_SET + ReflectionHelper.capitalize(field), value.getClass());
        m.invoke(object, value);
    }

    private static Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static String capitalize(String property) {
        return property.substring(0, 1).toUpperCase() + property.substring(1);
    }
}

