/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.util.Iterator;

public class StringHelper {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static boolean isEmpty(String value) {
        return value != null ? value.length() == 0 : true;
    }

    public static boolean isNullOrEmptyString(Object value) {
        return value == null || value.toString().trim().isEmpty();
    }

    public static String lineSeparator() {
        return LINE_SEPARATOR;
    }

    public static String toString(Object[] array) {
        int len = array.length;
        if (len == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(len * 12);
        for (int i = 0; i < len - 1; ++i) {
            buf.append(array[i]).append(", ");
        }
        return buf.append(array[len - 1]).toString();
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        return StringHelper.join(iterable.iterator(), separator);
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            sb.append(separator);
            sb.append(iterator.next());
        }
        if (sb.length() > 0) {
            return sb.substring(separator.length());
        }
        return "";
    }

    public static String escapeDoubleQuotesForJson(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    builder.append("\\");
                }
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

